<div class="table-wrap">
	<div class="table-responsive">
		<table class="table table-sm text-white">
			<tbody>
				<tr>
					<td><?php echo $this->lang->line('title'); ?></td>
					<td><?php echo $event->title; ?></td>
					<td><?php echo $this->lang->line('event_for'); ?></td>
					<td><?php echo $event->role; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('event_place'); ?></td>
					<td><?php echo $event->event_place; ?></td>
					<td><?php echo $this->lang->line('image'); ?></td>
					<td>
						<div class="avatar">
							<?php if ($event->image) { ?>
								<img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>event/<?php echo $event->image; ?>" alt="<?php echo $event->title; ?>" />
							<?php } ?>
						</div>
					</td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('from_date'); ?></td>
					<td><?php echo date('M d, Y h:ia', strtotime($event->event_from)); ?></td>
					<td><?php echo $this->lang->line('to_date'); ?></td>
					<td><?php echo date('M d, Y h:ia', strtotime($event->event_to)); ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('is_view_on_web'); ?></td>
					<td><?php echo $event->is_view_on_web ? '<span class="badge badge-success">' . $this->lang->line('yes') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('no') . '</span>'; ?></td>
					<td><?php echo $this->lang->line('status'); ?></td>
					<td><?php echo $event->status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?></td>
				</tr>
				<tr>
					<td colspan="4"><?php echo $this->lang->line('description'); ?></td>
				</tr>
				<tr>
					<td colspan="4"><?php echo $event->description; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('created_by'); ?></td>
					<td><?php echo $event->created_by; ?></td>
					<td><?php echo $this->lang->line('date'); ?></td>
					<td><?php echo date('d F, Y h:i A', strtotime($event->created_at)); ?></td>
				</tr>
				<?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
					<tr>
						<td><?php echo $this->lang->line('modified_by'); ?></td>
						<td><?php echo $event->modified_by; ?></td>
						<td><?php echo $this->lang->line('date'); ?></td>
						<td><?php echo $event->modified_by ? date('d F, Y h:i A', strtotime($event->modified_at)) : ''; ?>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>