<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('schedule'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_schedule'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('doctor/left-side'); ?>
        <!-- col-lg-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'doctor', 'schedule')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-clock-o font-30 mr-10"></i>
                            <?php if (isset($schedule) && !empty($schedule->id)) { ?>
                                <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('schedule'); ?>
                            <?php } else { ?>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('schedule'); ?>
                            <?php } ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'doctor', 'schedule')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('doctor/schedule'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('schedule'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('doctor/schedule/single'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control select2" name="doctor_id" id="doctor_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($schedule->doctor_id) && $schedule->doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="doctor_id" class="form-text text-muted">
                                <?php echo form_error('doctor_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="slot"><?php echo $this->lang->line('slot'); ?></label>
                            <select class="form-control custom-select" name="slot" id="slot" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('slot'); ?></option>
                                <?php $slots = get_schedule_slot(); ?>
                                <?php foreach ($slots as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($schedule->slot) && $schedule->slot == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="slot" class="form-text text-muted">
                                <?php echo form_error('slot'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($schedule->date) ?  $schedule->date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="date" class="form-text text-muted">
                                <?php echo form_error('date'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="start_time"><?php echo $this->lang->line('start_time'); ?></label>
                            <input type="text" class="form-control time" name="start_time" id="start_time" value="<?php echo isset($schedule->start_time) ?  $schedule->start_time : ''; ?>" placeholder="<?php echo $this->lang->line('start_time'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="start_time" class="form-text text-muted">
                                <?php echo form_error('start_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="end_time"><?php echo $this->lang->line('end_time'); ?></label>
                            <input type="text" class="form-control time" name="end_time" id="end_time" value="<?php echo isset($schedule->end_time) ?  $schedule->end_time : ''; ?>" placeholder="<?php echo $this->lang->line('end_time'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="end_time" class="form-text text-muted">
                                <?php echo form_error('end_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="per_patient_time"><?php echo $this->lang->line('per_patient_time'); ?></label>
                            <input type="number" class="form-control" name="per_patient_time" id="per_patient_time" value="<?php echo isset($schedule->per_patient_time) ?  $schedule->per_patient_time : ''; ?>" placeholder="<?php echo $this->lang->line('per_patient_time'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="per_patient_time" class="form-text text-muted">
                                <?php echo form_error('per_patient_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mt-10">
                            <div class="custom-control custom-checkbox checkbox-cyan mt-30">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo isset($schedule) && $schedule->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="remark" id="remark" aria-label="<?php echo $this->lang->line('schedule'); ?> <?php echo $this->lang->line('remark'); ?>"><?php echo isset($schedule->remark) ?  $schedule->remark : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <?php if (isset($schedule) && !empty($schedule->id)) { ?>
                            <input type="hidden" name="id" value="<?php echo $schedule->id; ?>">
                        <?php } ?>
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('doctor/schedule'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo isset($schedule) ? $this->lang->line('update') : $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<!-- Time Picker -->
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.css" rel="stylesheet" type="text/css" />
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker-theme.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.js"></script>


<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('.time').mdtimepicker({
        timeFormat: 'hh:mm:ss.000',
        format: 'h:mm tt',
        // theme of the timepicker
        // 'red', 'purple', 'indigo', 'teal', 'green', 'dark'
        theme: 'teal',
        readOnly: false,
        hourPadding: false,
        clearBtn: true
    });
    $("#date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY-MM-DD',
        }
    });
</script>