<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('manage_user'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_user'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-users font-30 mr-10"></i>
                        <?php echo $this->lang->line('manage_user'); ?>
                    </h6>
                    <div class="align-items-center">
                        <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                            <i class="fa fa-dashboard"></i>
                            <?php echo $this->lang->line('dashboard'); ?>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('setting/user'), array('method' => 'get', 'name' => 'user', 'id' => 'user', 'class' => 'form-inline needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <div class="form-row align-items-center">
                        <div class="col-auto">
                            <select class="form-control custom-select" name="role_id" id="role_id" onchange="get_user_by_role(this.value, '', '');">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($role_id) && $role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-auto">
                            <select class="form-control custom-select" name="user_id" id="user_id">
                                <option value=""><?php echo $this->lang->line('select'); ?></option>
                            </select>
                        </div>
                        <div class="col-auto">
                            <button type="submit" class="btn btn-primary mb-2"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0 mt-30">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('photo'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('email'); ?></th>
                                        <th><?php echo $this->lang->line('created'); ?></th>
                                        <th><?php echo $this->lang->line('login'); ?> <?php echo $this->lang->line('status'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($users) && !empty($users)) {  ?>
                                        <?php foreach ($users as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count;  ?></td>
                                                <td>
                                                    <div class="avatar mr-10">
                                                        <?php if ($obj->photo) { ?>
                                                            <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $obj->photo; ?>" alt="<?php echo $obj->name; ?>">
                                                        <?php } elseif ($obj->gender == 'male') { ?>
                                                            <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>male.png" alt="male" />
                                                        <?php } else { ?>
                                                            <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>female.png" alt="female" />
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                                <td><?php echo $obj->email; ?></td>
                                                <td><?php echo date($this->global_setting->date_format, strtotime($obj->created_at)); ?></td>
                                                <td>
                                                    <div class="toggle-wrap">
                                                        <div data-toggle-on="<?php echo $obj->status ? 'true' : 'false'; ?>" id="<?php echo $obj->user_id; ?>" status="<?php echo $obj->status ? '0' : '1'; ?>" class="toggle toggle-light toggle-bg-primary _status status_update"></div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->
<!-- Toggles CSS -->
<link href="<?php echo VENDOR_URL;  ?>jquery-toggles/css/toggles.css" rel="stylesheet" type="text/css">
<link href="<?php echo VENDOR_URL;  ?>jquery-toggles/css/themes/toggles-light.css" rel="stylesheet" type="text/css">
<!-- Toggles JavaScript -->
<script src="<?php echo VENDOR_URL; ?>jquery-toggles/toggles.min.js"></script>

<script>
    <?php if (isset($role_id)) { ?>
        get_user_by_role('<?php echo $role_id;  ?>', '<?php echo $user_id; ?>');
    <?php } ?>

    function get_user_by_role(role_id, user_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_user_by_role'); ?>",
            data: {
                role_id: role_id,
                user_id: user_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#user_id').html(response);
                }
            }
        });
    }
</script>


<script>
    $('._status').toggles({
        drag: true, // allow dragging the toggle between positions
        click: true, // allow clicking on the toggle
        text: {
            on: '<?php echo $this->lang->line('on'); ?>', // text for the ON position
            off: '<?php echo $this->lang->line('off'); ?>' // and off
        },
        on: true, // is the toggle ON on init
        animate: 250, // animation time (ms)
        easing: 'swing', // animation transition easing function
        checkbox: null, // the checkbox to toggle (for use in forms)
        clicker: null, // element that can be clicked on to toggle. removes binding from the toggle itself (use nesting)

        type: 'compact' // if this is set to 'select' then the select style toggle will be used
    });
</script>

<script>
    $('.status_update').click(function() {
        var user_id = $(this).attr('id');
        var status = $(this).attr('status');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/update_user_status'); ?>",
            data: {
                user_id: user_id,
                status: status
            },
            async: false,
            success: function(response) {
                if (response) {
                    $.toast({
                        heading: 'Success !',
                        text: '<p><?php echo $this->lang->line('update_success'); ?></p>',
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-primary',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                    location.reload();
                }
            }
        });
    });
</script>