<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('marketing'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
                <a href="<?php echo site_url('report/marketing/investigation'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('investigation'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
                <a href="<?php echo site_url('report/marketing/income'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('income'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">

        <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-bunting">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('income'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/marketing/income'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('income'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('collection'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/marketing/investigation'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('collection'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('vd'); ?> <?php echo $this->lang->line('collection'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/marketing/vd'); ?>" class="btn btn-success">
                           <?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('income'); ?> <?php echo $this->lang->line('bill'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->