<!DOCTYPE html>
<html>

<head>
    <title>Employee</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            /* page-break-after: always; */
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->

            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($role_id) && !empty($role_id)) { ?>
                                    <b>Role:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;"><?php echo $role->name; ?></span>
                                <?php } else { ?>
                                    <b>Role:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">All</span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width:4%"><?php echo $this->lang->line('sl_no'); ?></th>
                            <th style="width:8%"><?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('id'); ?></th>
                            <th><?php echo $this->lang->line('name'); ?></th>
                            <th style="width:10%"><?php echo $this->lang->line('department'); ?></th>
                            <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                <th><?php echo $this->lang->line('specialist'); ?></th>
                            <?php } else { ?>
                                <th><?php echo $this->lang->line('designation'); ?></th>
                            <?php } ?>
                            <th style="width:8%"><?php echo $this->lang->line('blood_group'); ?></th>
                            <th style="width:8%"><?php echo $this->lang->line('national_id'); ?></th>
                            <th style="width:10%"><?php echo $this->lang->line('phone'); ?></th>
                            <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                <th><?php echo $this->lang->line('first_fee'); ?></th>
                                <th><?php echo $this->lang->line('second_fee'); ?></th>
                                <th><?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('commission'); ?></th>
                            <?php } ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        if (isset($employees) && !empty($employees)) { ?>
                            <?php foreach ($employees as $obj) { ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->device_id; ?></td>
                                    <td><?php echo $obj->name; ?></td>
                                    <td><?php echo $obj->department; ?></td>
                                    <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                        <td><?php echo $obj->specialist; ?></td>
                                    <?php } else { ?>
                                        <td><?php echo $obj->designation; ?></td>
                                    <?php } ?>
                                    <td><?php echo $this->lang->line($obj->blood_group); ?></td>
                                    <td><?php echo $obj->national_id; ?></td>
                                    <td><?php echo $obj->phone; ?></td>
                                    <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                        <td><?php echo $obj->first_fee; ?></td>
                                        <td><?php echo $obj->second_fee; ?></td>
                                        <td><?php echo $obj->hospital_commission; ?></td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                        <?php } else { ?>
                            <tr class="text-center">
                                <td colspan="8"><?php echo $this->lang->line('no_data_found'); ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>