<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Mis.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Mis
 * @description     : Manage MIS report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Mis extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('Mis_Model', 'mis', true);
        $this->data['doctors'] = $this->mis->get_doctor_list();
        $this->data['references'] = $this->mis->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->mis->get_employee_list();
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Mis Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index()
    {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('mis') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/index', $this->data);
    }

    /*****************Function credit**********************************
     * @type            : Function
     * @function name   : credit
     * @description     : Load "Hospital Credit Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function credit()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['opd_income'] = $this->mis->get_opd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_income'] = $this->mis->get_ipd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_income'] = $this->mis->get_diagnostic_income($type, $form_date, $to_date, $reference_id, $created_by);
            //$this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['opd_expense'] = $this->mis->get_opd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('credit') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/credit', $this->data);
    }

    /*****************Function credit_pdf**********************************
     * @type            : Function
     * @function name   : credit_pdf
     * @description     : Load "Generate Hospital Credit Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function credit_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['opd_income'] = $this->mis->get_opd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_income'] = $this->mis->get_ipd_income($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_income'] = $this->mis->get_diagnostic_income($type, $form_date, $to_date, $reference_id, $created_by);
            //$this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['opd_expense'] = $this->mis->get_opd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['reference'] = $this->mis->get_single('employees', array('user_id' => $reference_id, 'status' => 1));

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/credit', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('credit_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function transaction**********************************
     * @type            : Function
     * @function name   : transaction
     * @description     : Load "Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function transaction()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['opd_transaction'] = $this->mis->get_opd_transaction($form_date, $to_date, $created_by);
            $this->data['ipd_transaction'] = $this->mis->get_ipd_transaction($form_date, $to_date, $created_by);
            $this->data['diagnostic_transaction'] = $this->mis->get_diagnostic_transaction($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('transaction') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/transaction', $this->data);
    }

    /*****************Function transaction_pdf**********************************
     * @type            : Function
     * @function name   : transaction_pdf
     * @description     : Load "Generate Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function transaction_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['opd_transaction'] = $this->mis->get_opd_transaction($form_date, $to_date, $created_by);
            $this->data['ipd_transaction'] = $this->mis->get_ipd_transaction($form_date, $to_date, $created_by);
            $this->data['diagnostic_transaction'] = $this->mis->get_diagnostic_transaction($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['pharmacy_income'] = $this->mis->get_pharmacy_income($type, $form_date, $to_date, $created_by);
            $this->data['incomes'] = $this->mis->get_income($form_date, $to_date, $created_by);

            // Expense
            $this->data['ipd_expense'] = $this->mis->get_ipd_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['diagnostic_expense'] = $this->mis->get_diagnostic_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['surgeon_expense'] = $this->mis->get_surgeon_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['anesthesia_expense'] = $this->mis->get_anesthesia_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['assistant_expense'] = $this->mis->get_assistant_expense($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['expenditures'] = $this->mis->get_expenditure($form_date, $to_date, $created_by);

            $this->data['reference'] = $this->mis->get_single('employees', array('user_id' => $reference_id, 'status' => 1));

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/transaction', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('transaction_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function summery**********************************
     * @type            : Function
     * @function name   : summery
     * @description     : Load "Hospital summery Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function summery()
    {

        check_permission(VIEW);

        if ($_GET) {

            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = date('Y-m-d');
                $to_date = date('Y-m-d');
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');


            $start = new DateTime($form_date);
            $end = new DateTime($to_date);

            $date_range = [];
            while ($start <= $end) {

                $ipd_income = $this->mis->get_ipd_transaction($start->format('Y-m-d'), $start->format('Y-m-d'), $created_by)->total_ipd_transaction ?? 0;
                $diagnostic_income = $this->mis->get_diagnostic_transaction($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_diagnostic_transaction ?? 0;
                $opd_income = $this->mis->get_opd_transaction($start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_opd_transaction ?? 0;
                $income = $this->mis->get_incomes($start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_income ?? 0;

                $ipd_expense = $this->mis->get_ipd_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_ipd_expense ?? 0;
                $diagnostic_expense = $this->mis->get_diagnostic_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_diagnostic_expense ?? 0;
                $surgeon_expense = $this->mis->get_surgeon_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_surgeon_expense ?? 0;
                $anesthetist_expense = $this->mis->get_anesthesia_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_anesthesia_expense ?? 0;
                $assistant_expense = $this->mis->get_assistant_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_assistant_expense ?? 0;
                $expense = $this->mis->get_expenditures($start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_expenditure_expense ?? 0;

                // Calculate total income
                $total_income = $ipd_income + $diagnostic_income + $opd_income + $income;
                $total_expense = $ipd_expense + $diagnostic_expense + $surgeon_expense + $anesthetist_expense + $assistant_expense + $expense;
                $total = ($total_income - $total_expense);

                $date_range[] = [
                    'date' => $start->format('d/m/Y'),
                    'ipd_income' => $ipd_income > 0 ? $ipd_income : $ipd_income,
                    'diagnostic_income' => $diagnostic_income > 0 ? $diagnostic_income : $diagnostic_income,
                    'opd_income' => $opd_income > 0 ? $opd_income : $opd_income,
                    'income' => $income > 0 ? $income : $income,
                    'total_income' => $total_income > 0 ? $total_income : $total_income,
                    'ipd_expense' => $ipd_expense > 0 ? $ipd_expense : $ipd_expense,
                    'diagnostic_expense' => $diagnostic_expense > 0 ? $diagnostic_expense : $diagnostic_expense,
                    'surgeon_expense' => $surgeon_expense > 0 ? $surgeon_expense : $surgeon_expense,
                    'anesthetist_expense' => $anesthetist_expense > 0 ? $anesthetist_expense : $anesthetist_expense,
                    'assistant_expense' => $assistant_expense > 0 ? $assistant_expense : $assistant_expense,
                    'expense' => $expense > 0 ? $expense : $expense,
                    'total_expense' => $total_expense > 0 ? $total_expense : $total_expense,
                    'total' => $total > 0 ? $total : $total
                ];
                $start->modify('+1 day');
            }

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->data['date_range'] = $date_range;
        }
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('summery') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/summery', $this->data);
    }

    /*****************Function summery_pdf**********************************
     * @type            : Function
     * @function name   : summery_pdf
     * @description     : Load "Generate Hospital summery Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function summery_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = date('Y-m-d');
                $to_date = date('Y-m-d');
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');


            $start = new DateTime($form_date);
            $end = new DateTime($to_date);

            $date_range = [];
            while ($start <= $end) {

                $ipd_income = $this->mis->get_ipd_transaction($start->format('Y-m-d'), $start->format('Y-m-d'), $created_by)->total_ipd_transaction ?? 0;
                $diagnostic_income = $this->mis->get_diagnostic_transaction($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_diagnostic_transaction ?? 0;
                $opd_income = $this->mis->get_opd_transaction($start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_opd_transaction ?? 0;
                $income = $this->mis->get_incomes($start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_income ?? 0;

                $ipd_expense = $this->mis->get_ipd_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_ipd_expense ?? 0;
                $diagnostic_expense = $this->mis->get_diagnostic_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_diagnostic_expense ?? 0;
                $surgeon_expense = $this->mis->get_surgeon_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_surgeon_expense ?? 0;
                $anesthetist_expense = $this->mis->get_anesthesia_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_anesthesia_expense ?? 0;
                $assistant_expense = $this->mis->get_assistant_expense($type, $start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_assistant_expense ?? 0;
                $expense = $this->mis->get_expenditures($start->format('Y-m-d'), $start->format('Y-m-d'), $reference_id, $created_by)->total_expenditure_expense ?? 0;

                // Calculate total income
                $total_income = $ipd_income + $diagnostic_income + $opd_income + $income;
                $total_expense = $ipd_expense + $diagnostic_expense + $surgeon_expense + $anesthetist_expense + $assistant_expense + $expense;
                $total = ($total_income - $total_expense);

                $date_range[] = [
                    'date' => $start->format('d/m/Y'),
                    'ipd_income' => $ipd_income > 0 ? $ipd_income : $ipd_income,
                    'diagnostic_income' => $diagnostic_income > 0 ? $diagnostic_income : $diagnostic_income,
                    'opd_income' => $opd_income > 0 ? $opd_income : $opd_income,
                    'income' => $income > 0 ? $income : $income,
                    'total_income' => $total_income > 0 ? $total_income : $total_income,
                    'ipd_expense' => $ipd_expense > 0 ? $ipd_expense : $ipd_expense,
                    'diagnostic_expense' => $diagnostic_expense > 0 ? $diagnostic_expense : $diagnostic_expense,
                    'surgeon_expense' => $surgeon_expense > 0 ? $surgeon_expense : $surgeon_expense,
                    'anesthetist_expense' => $anesthetist_expense > 0 ? $anesthetist_expense : $anesthetist_expense,
                    'assistant_expense' => $assistant_expense > 0 ? $assistant_expense : $assistant_expense,
                    'expense' => $expense > 0 ? $expense : $expense,
                    'total_expense' => $total_expense > 0 ? $total_expense : $total_expense,
                    'total' => $total > 0 ? $total : $total
                ];
                $start->modify('+1 day');
            }
            $this->data['reference'] = $this->mis->get_single('employees', array('user_id' => $reference_id, 'status' => 1));

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->data['date_range'] = $date_range;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/summery', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('summery' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function opd**********************************
     * @type            : Function
     * @function name   : opd
     * @description     : Load "Hospital opd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function opd()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            //$this->data['investigations'] = $this->mis->get_investigations($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['investigations'] = $this->mis->get_due_investigations(1, $type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['due_investigations'] = $this->mis->get_due_investigations(2, $type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['vd_payments'] = $this->mis->get_vd_payments($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['opd_other_incomes'] = $this->mis->get_opd_other_incomes($form_date, $to_date, $created_by);
            $this->data['opd_other_expenses'] = $this->mis->get_opd_other_expenses($form_date, $to_date, $created_by);

            // Sum
            $total_investigations = 0;
            foreach ($this->data['investigations'] as $row) {
                $total_investigations += $row->amount ?? 0;
            }

            $total_due_investigations = 0;
            foreach ($this->data['due_investigations'] as $row) {
                $total_due_investigations += $row->amount ?? 0;
            }

            $total_vd_payments = 0;
            foreach ($this->data['vd_payments'] as $row) {
                $total_vd_payments += $row->payable_amount ?? 0;
            }

            $total_opd_other_incomes = 0;
            foreach ($this->data['opd_other_incomes'] as $row) {
                $total_opd_other_incomes += $row->amount ?? 0;
            }

            $total_opd_other_expenses = 0;
            foreach ($this->data['opd_other_expenses'] as $row) {
                $total_opd_other_expenses += $row->amount ?? 0;
            }

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;


            $this->data['total_investigations'] = $total_investigations;
            $this->data['total_due_investigations'] = $total_due_investigations;
            $this->data['total_vd_payments'] = $total_vd_payments;
            $this->data['total_opd_other_incomes'] = $total_opd_other_incomes;
            $this->data['total_opd_other_expenses'] = $total_opd_other_expenses;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('opd') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/opd', $this->data);
    }

    /*****************Function opd_pdf**********************************
     * @type            : Function
     * @function name   : opd_pdf
     * @description     : Load "Generate Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function opd_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['investigations'] = $this->mis->get_due_investigations(1, $type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['due_investigations'] = $this->mis->get_due_investigations(2, $type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['vd_payments'] = $this->mis->get_vd_payments($type, $form_date, $to_date, $reference_id, $created_by);
            $this->data['opd_other_incomes'] = $this->mis->get_opd_other_incomes($form_date, $to_date, $created_by);
            $this->data['opd_other_expenses'] = $this->mis->get_opd_other_expenses($form_date, $to_date, $created_by);

            // Sum
            $total_investigations = 0;
            foreach ($this->data['investigations'] as $row) {
                $total_investigations += $row->amount ?? 0;
            }

            $total_due_investigations = 0;
            foreach ($this->data['due_investigations'] as $row) {
                $total_due_investigations += $row->amount ?? 0;
            }

            $total_vd_payments = 0;
            foreach ($this->data['vd_payments'] as $row) {
                $total_vd_payments += $row->payable_amount ?? 0;
            }

            $total_opd_other_incomes = 0;
            foreach ($this->data['opd_other_incomes'] as $row) {
                $total_opd_other_incomes += $row->amount ?? 0;
            }

            $total_opd_other_expenses = 0;
            foreach ($this->data['opd_other_expenses'] as $row) {
                $total_opd_other_expenses += $row->amount ?? 0;
            }

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;


            $this->data['total_investigations'] = $total_investigations;
            $this->data['total_due_investigations'] = $total_due_investigations;
            $this->data['total_vd_payments'] = $total_vd_payments;
            $this->data['total_opd_other_incomes'] = $total_opd_other_incomes;
            $this->data['total_opd_other_expenses'] = $total_opd_other_expenses;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/opd', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('opd_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function ipd**********************************
     * @type            : Function
     * @function name   : ipd
     * @description     : Load "Hospital opd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function ipd()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['ipd_invoices'] = $this->mis->get_ipd_invoices($form_date, $to_date, $created_by);
            $this->data['ipd_advance_payments'] = $this->mis->get_ipd_advance_payments($form_date, $to_date, $created_by);
            $this->data['ipd_due_invoices'] = $this->mis->get_ipd_due_invoices($form_date, $to_date, $created_by);


            $this->data['ipd_other_incomes'] = $this->mis->get_ipd_other_incomes($form_date, $to_date, $created_by);
            $this->data['surgeons'] = $this->mis->get_surgeons($form_date, $to_date, $created_by);
            $this->data['anesthetists'] = $this->mis->get_anesthetists($form_date, $to_date, $created_by);
            $this->data['assistants'] = $this->mis->get_assistants($form_date, $to_date, $created_by);
            $this->data['ipd_other_expenses'] = $this->mis->get_ipd_other_expenses($form_date, $to_date, $created_by);

            // Sum
            $total_ipd_invoices = 0;
            foreach ($this->data['ipd_invoices'] as $row) {
                $total_ipd_invoices += $row->amount ?? 0;
            }

            $total_ipd_advance_payments = 0;
            foreach ($this->data['ipd_advance_payments'] as $row) {
                $total_ipd_advance_payments += $row->amount ?? 0;
            }

            $total_ipd_due_invoices = 0;
            foreach ($this->data['ipd_due_invoices'] as $row) {
                $total_ipd_due_invoices += $row->amount ?? 0;
            }

            $total_ipd_other_incomes = 0;
            foreach ($this->data['ipd_other_incomes'] as $row) {
                $total_ipd_other_incomes += $row->amount ?? 0;
            }

            $total_surgeons = 0;
            foreach ($this->data['surgeons'] as $row) {
                $total_surgeons += $row->payable_amount ?? 0;
            }

            $total_anesthetists = 0;
            foreach ($this->data['anesthetists'] as $row) {
                $total_anesthetists += $row->payable_amount ?? 0;
            }

            $total_assistants = 0;
            foreach ($this->data['assistants'] as $row) {
                $total_assistants += $row->payable_amount ?? 0;
            }

            $total_ipd_other_expenses = 0;
            foreach ($this->data['ipd_other_expenses'] as $row) {
                $total_ipd_other_expenses += $row->amount ?? 0;
            }

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;


            $this->data['total_ipd_invoices'] = $total_ipd_invoices;
            $this->data['total_ipd_advance_payments'] = $total_ipd_advance_payments;
            $this->data['total_ipd_due_invoices'] = $total_ipd_due_invoices;
            $this->data['total_ipd_other_incomes'] = $total_ipd_other_incomes;
            $this->data['total_surgeons'] = $total_surgeons;
            $this->data['total_anesthetists'] = $total_anesthetists;
            $this->data['total_assistants'] = $total_assistants;
            $this->data['total_ipd_other_expenses'] = $total_ipd_other_expenses;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('ipd') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/ipd', $this->data);
    }

    /*****************Function opd_pdf**********************************
     * @type            : Function
     * @function name   : opd_pdf
     * @description     : Load "Generate Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function ipd_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $type = $this->input->get('type');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['ipd_invoices'] = $this->mis->get_ipd_invoices($form_date, $to_date, $created_by);
            $this->data['ipd_advance_payments'] = $this->mis->get_ipd_advance_payments($form_date, $to_date, $created_by);
            $this->data['ipd_due_invoices'] = $this->mis->get_ipd_due_invoices($form_date, $to_date, $created_by);


            $this->data['ipd_other_incomes'] = $this->mis->get_ipd_other_incomes($form_date, $to_date, $created_by);
            $this->data['surgeons'] = $this->mis->get_surgeons($form_date, $to_date, $created_by);
            $this->data['anesthetists'] = $this->mis->get_anesthetists($form_date, $to_date, $created_by);
            $this->data['assistants'] = $this->mis->get_assistants($form_date, $to_date, $created_by);
            $this->data['ipd_other_expenses'] = $this->mis->get_ipd_other_expenses($form_date, $to_date, $created_by);

            // Sum
            $total_ipd_invoices = 0;
            foreach ($this->data['ipd_invoices'] as $row) {
                $total_ipd_invoices += $row->amount ?? 0;
            }

            $total_ipd_advance_payments = 0;
            foreach ($this->data['ipd_advance_payments'] as $row) {
                $total_ipd_advance_payments += $row->amount ?? 0;
            }

            $total_ipd_due_invoices = 0;
            foreach ($this->data['ipd_due_invoices'] as $row) {
                $total_ipd_due_invoices += $row->amount ?? 0;
            }

            $total_ipd_other_incomes = 0;
            foreach ($this->data['ipd_other_incomes'] as $row) {
                $total_ipd_other_incomes += $row->amount ?? 0;
            }

            $total_surgeons = 0;
            foreach ($this->data['surgeons'] as $row) {
                $total_surgeons += $row->payable_amount ?? 0;
            }

            $total_anesthetists = 0;
            foreach ($this->data['anesthetists'] as $row) {
                $total_anesthetists += $row->payable_amount ?? 0;
            }

            $total_assistants = 0;
            foreach ($this->data['assistants'] as $row) {
                $total_assistants += $row->payable_amount ?? 0;
            }

            $total_ipd_other_expenses = 0;
            foreach ($this->data['ipd_other_expenses'] as $row) {
                $total_ipd_other_expenses += $row->amount ?? 0;
            }

            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['total_ipd_invoices'] = $total_ipd_invoices;
            $this->data['total_ipd_advance_payments'] = $total_ipd_advance_payments;
            $this->data['total_ipd_due_invoices'] = $total_ipd_due_invoices;
            $this->data['total_ipd_other_incomes'] = $total_ipd_other_incomes;
            $this->data['total_surgeons'] = $total_surgeons;
            $this->data['total_anesthetists'] = $total_anesthetists;
            $this->data['total_assistants'] = $total_assistants;
            $this->data['total_ipd_other_expenses'] = $total_ipd_other_expenses;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/ipd', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('ipd_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function visitor**********************************
     * @type            : Function
     * @function name   : ipd
     * @description     : Load "Hospital opd Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function visitor()
    {

        check_permission(VIEW);

        if ($_GET) {
            $search = $this->input->get('search');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $pregnancy = $this->input->get('pregnancy');
            $treatment = $this->input->get('treatment');
            $card = $this->input->get('card');
            $package = $this->input->get('package');
            $land = $this->input->get('land');
            $operation = $this->input->get('operation');
            $test = $this->input->get('test');
            $created_by = $this->input->get('created_by');

            $this->data['visitors'] = $this->mis->get_visitor_list($search, $form_date, $to_date, $pregnancy, $treatment, $card, $package, $land, $operation, $test, $created_by);

            $this->data['search'] = $search;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['pregnancy'] = $pregnancy;
            $this->data['treatment'] = $treatment;
            $this->data['card'] = $card;
            $this->data['package'] = $package;
            $this->data['land'] = $land;
            $this->data['operation'] = $operation;
            $this->data['test'] = $test;
            $this->data['created_by'] = $created_by;
        }
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('visitor') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/mis/visitor', $this->data);
    }


    /*****************Function visitor_pdf**********************************
     * @type            : Function
     * @function name   : opd_pdf
     * @description     : Load "Generate Hospital Transaction Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function visitor_pdf()
    {

        check_permission(VIEW);

        if ($_GET) {
            $search = $this->input->get('search');
            if (!empty($this->input->get('date'))) {
                $date = $this->input->get('date');
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $date = null;
                $form_date = null;
                $to_date = null;
            }
            $pregnancy = $this->input->get('pregnancy');
            $treatment = $this->input->get('treatment');
            $card = $this->input->get('card');
            $package = $this->input->get('package');
            $land = $this->input->get('land');
            $operation = $this->input->get('operation');
            $test = $this->input->get('test');
            $created_by = $this->input->get('created_by');

            $this->data['visitors'] = $this->mis->get_visitor_list($search, $form_date, $to_date, $pregnancy, $treatment, $card, $package, $land, $operation, $test, $created_by);

            $this->data['search'] = $search;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['pregnancy'] = $pregnancy;
            $this->data['treatment'] = $treatment;
            $this->data['card'] = $card;
            $this->data['package'] = $package;
            $this->data['land'] = $land;
            $this->data['operation'] = $operation;
            $this->data['test'] = $test;
            $this->data['created_by'] = $created_by;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/mis/pdf/visitor', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('visitor_' . rand() . '.pdf', 'I');
        }
    }
}
