<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Appointment.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Appointment
 * @description     : Manage apointment report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Appointment extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Appointment_Model', 'appointment', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Appointment Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = isset($exp[1]) && !empty($exp[1]) ? date('Y-m-d', strtotime($exp[1])) : $form_date;
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['appointments'] = $this->appointment->get_appointment_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['doctors'] = $this->appointment->get_doctor_list();
        $this->data['references'] = $this->appointment->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->appointment->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('appointment') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/appointment/index', $this->data);
    }

    public function pdf() {
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = isset($exp[1]) && !empty($exp[1]) ? date('Y-m-d', strtotime($exp[1])) : $form_date;
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');
            $this->data['appointments'] = $this->appointment->get_appointment_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);

            $this->data['form_date'] = $form_date;
            $this->data['doctor'] = $this->appointment->get_single_doctor($doctor_id);

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'P'
            ]);
            $html =  $this->load->view('report/appointment/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('appointment_' . rand() . '.pdf', 'D');
        }
    }
}
