<!DOCTYPE html>
<html>

<head>
    <title>Refund</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tfoot th {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">PHARMACY REFUND REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($manufacturer) && !empty($manufacturer)) { ?>
                                    <b>Manufacturer:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $manufacturer->name; ?>, <?php echo $manufacturer->phone; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Manufacturer:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                            <th><?php echo $this->lang->line('invoice_no'); ?></th>
                            <th><?php echo $this->lang->line('date'); ?></th>
                            <?php if ($type == 1) { ?>
                                <th><?php echo $this->lang->line('customer'); ?></th>
                            <?php } elseif ($type == 2) { ?>
                                <th><?php echo $this->lang->line('manufacturer'); ?></th>
                            <?php } elseif ($type == 3) { ?>
                                <th><?php echo $this->lang->line('wastage'); ?></th>
                            <?php } else { ?>
                                <th><?php echo $this->lang->line('type'); ?></th>
                            <?php }  ?>
                            <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                            <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('refund'); ?></th>
                            <th><?php echo $this->lang->line('discount'); ?></th>
                            <th><?php echo $this->lang->line('net_payable'); ?></th>
                            <th><?php echo $this->lang->line('advanced'); ?></th>
                            <th><?php echo $this->lang->line('due_amount'); ?></th>
                            <th><?php echo $this->lang->line('created_by'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_bill_amount = 0;
                        $total_refund_amount = 0;
                        $total_discount = 0;
                        $total_net_payable = 0;
                        $total_advanced = 0;
                        $total_due_amount = 0;
                        if (isset($refunds) && !empty($refunds)) { ?>
                            <?php foreach ($refunds as $obj) {
                                $total_bill_amount += $obj->total_bill;
                                $total_refund_amount += $obj->total_refund;
                                $total_discount += $obj->discount;
                                $total_net_payable += $obj->net_payable;
                                $total_advanced += $obj->advanced;
                                $total_due_amount += $obj->due_amount;
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo date('d/m/Y h:ia', strtotime($obj->bill_date)); ?></td>
                                    <?php if ($type == 1) { ?>
                                        <td>
                                            <?php
                                            if ($obj->walking == 1) {
                                                echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                            } elseif ($obj->customer_id > 0) {
                                                echo $obj->customer;
                                            } else {
                                                echo $obj->customer_name;
                                            }
                                            ?>
                                        </td>
                                    <?php } elseif ($type == 2) { ?>
                                        <td><?php echo $obj->manufacturer; ?></td>
                                    <?php } elseif ($type == 3) { ?>
                                        <td><?php echo $this->lang->line('wastage'); ?></td>
                                    <?php } else { ?>
                                        <td>
                                            <?php
                                            if ($obj->walking == 1) {
                                                echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                            } elseif ($obj->customer_id > 0) {
                                                echo $obj->customer;
                                            } elseif ($obj->customer_name) {
                                                echo $obj->customer_name;
                                            } elseif ($obj->manufacturer) {
                                                echo $obj->manufacturer;
                                            } else {
                                                echo 'wastage';
                                            }
                                            ?>
                                        </td>
                                    <?php }  ?>
                                    <td><?php echo $obj->total_bill; ?></td>
                                    <td><?php echo $obj->total_refund; ?></td>
                                    <td><?php echo $obj->discount; ?></td>
                                    <td><?php echo $obj->net_payable; ?></td>
                                    <td><?php echo $obj->advanced; ?></td>
                                    <td><?php echo $obj->due_amount; ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="4" align="right">Total</th>
                            <th><?php echo number_format($total_bill_amount, 2); ?></th>
                            <th><?php echo number_format($total_refund_amount, 2); ?></th>
                            <th><?php echo number_format($total_discount, 2); ?></th>
                            <th><?php echo number_format($total_net_payable, 2); ?></th>
                            <th><?php echo number_format($total_advanced, 2); ?></th>
                            <th><?php echo number_format($total_due_amount, 2); ?></th>
                            <th></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php if (isset($created_by) && !empty($created_by)) {
                                        echo $createdby->name;
                                    } else {
                                        echo $this->session->userdata('name');
                                    } ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>