<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('medicine'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_medicine'); ?>
        </h4>

        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-medkit font-12 mr-5"></i>
                    <?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('list'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/type'); ?>" class="btn btn-xs btn-primary">
                    <i class="fa fa-medkit font-12 mr-5"></i>
                    <?php echo $this->lang->line('type'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/category'); ?>" class="btn btn-xs btn-warning">
                    <i class="fa fa-user-md font-12 mr-5"></i>
                    <?php echo $this->lang->line('category'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/generic'); ?>" class="btn btn-xs btn-indigo">
                    <i class="fa fa-ravelry font-12 mr-5"></i>
                    <?php echo $this->lang->line('generic'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/unit'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('unit'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <!-- Search Start-->
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('pharmacy/medicine/price'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="category_id"><?php echo $this->lang->line('category'); ?></label>
                            <select class="form-control select2" name="category_id" id="category_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($categories as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($category_id) && $category_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="manufacturer_id"><?php echo $this->lang->line('manufacturer'); ?></label>
                            <select class="form-control select2" name="manufacturer_id" id="manufacturer_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($manufacturers as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($manufacturer_id) && $manufacturer_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="generic_id"><?php echo $this->lang->line('generic'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control select2" name="generic_id" id="generic_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($generics as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($generic_id) && $generic_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
            <!-- Search End-->

            <?php if (isset($medicines) && !empty($medicines)) { ?>
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-medkit font-30 mr-10"></i>
                                <?php echo $this->lang->line('medicine_list'); ?>
                            </h6>
                        <?php } ?>
                    </div>
                    <?php echo form_open_multipart(site_url('pharmacy/medicine/price'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th width="20%"><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('strength'); ?></th>
                                            <th><?php echo $this->lang->line('rack_no'); ?></th>
                                            <th><?php echo $this->lang->line('mrp'); ?></th>
                                            <th><?php echo $this->lang->line('purchase'); ?></th>
                                            <th><?php echo $this->lang->line('sell'); ?></th>
                                            <th><?php echo $this->lang->line('wholesale'); ?></th>
                                            <th><?php echo $this->lang->line('minimum'); ?> <?php echo $this->lang->line('stock'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $sl = 1;
                                        foreach ($medicines as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl++; ?></td>
                                                <td>
                                                    <?php echo $obj->category; ?> =>
                                                    <?php echo $obj->medicine_name; ?>
                                                    <input type="hidden" name="medicine_id[]" value="<?php echo $obj->id; ?>">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="strength" name="strength[<?php echo $obj->id; ?>]" value="<?php echo $obj->strength; ?>" placeholder="<?php echo $this->lang->line('strength'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="rack_no" name="rack_no[<?php echo $obj->id; ?>]" value="<?php echo $obj->rack_no; ?>" placeholder="<?php echo $this->lang->line('rack_no'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="mrp" name="mrp[<?php echo $obj->id; ?>]" value="<?php echo $obj->mrp; ?>" placeholder="<?php echo $this->lang->line('mrp'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="purchase_price" name="purchase_price[<?php echo $obj->id; ?>]" value="<?php echo $obj->purchase_price; ?>" placeholder="<?php echo $this->lang->line('purchase'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="sell_price" name="sell_price[<?php echo $obj->id; ?>]" value="<?php echo $obj->sell_price; ?>" placeholder="<?php echo $this->lang->line('sell'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="whole_sale_price" name="whole_sale_price[<?php echo $obj->id; ?>]" value="<?php echo $obj->whole_sale_price; ?>" placeholder="<?php echo $this->lang->line('wholesale'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="minimum_stock" name="minimum_stock[<?php echo $obj->id; ?>]" value="<?php echo $obj->minimum_stock; ?>" placeholder="<?php echo $this->lang->line('minimum'); ?>" autocomplete="off">
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <div class="card-footer pt-0">
                        <div class="button-list">
                            <a class="btn btn-gradient-danger" href="<?php echo site_url('pharmacy/medicine'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                            <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            <?php } ?>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
</script>