<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('medicine'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_medicine'); ?>
        </h4>

        <div class="align-items-center">
            <?php if (has_permission(ADD, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/price'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-pencil font-12 mr-5"></i>
                    <?php echo $this->lang->line('price'); ?> <?php echo $this->lang->line('update'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/type'); ?>" class="btn btn-xs btn-primary">
                    <i class="fa fa-medkit font-12 mr-5"></i>
                    <?php echo $this->lang->line('type'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/category'); ?>" class="btn btn-xs btn-warning">
                    <i class="fa fa-user-md font-12 mr-5"></i>
                    <?php echo $this->lang->line('category'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/generic'); ?>" class="btn btn-xs btn-indigo">
                    <i class="fa fa-ravelry font-12 mr-5"></i>
                    <?php echo $this->lang->line('generic'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                <a href="<?php echo site_url('pharmacy/medicine/unit'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('unit'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <!-- Search Start-->
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('pharmacy/medicine'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="type_id"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control select2" name="type_id" id="type_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($types as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($type_id) && $type_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="category_id"><?php echo $this->lang->line('category'); ?></label>
                            <select class="form-control select2" name="category_id" id="category_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($categories as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($category_id) && $category_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="manufacturer_id"><?php echo $this->lang->line('manufacturer'); ?></label>
                            <select class="form-control select2" name="manufacturer_id" id="manufacturer_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($manufacturers as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($manufacturer_id) && $manufacturer_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="generic_id"><?php echo $this->lang->line('generic'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control select2" name="generic_id" id="generic_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($generics as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($generic_id) && $generic_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="unit_id"><?php echo $this->lang->line('unit'); ?></label>
                            <select class="form-control select2" name="unit_id" id="unit_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($units as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($unit_id) && $unit_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
            <!-- Search End-->
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-medkit font-30 mr-10"></i>
                            <?php echo $this->lang->line('medicine_list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(ADD, 'pharmacy', 'medicine')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/medicine/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('medicine'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('photo'); ?></th>
                                        <th><?php echo $this->lang->line('category'); ?></th>
                                        <th><?php echo $this->lang->line('manufacturer'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('mrp'); ?></th>
                                        <th><?php echo $this->lang->line('purchase'); ?></th>
                                        <th><?php echo $this->lang->line('sale'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th width="18%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($medicines) && !empty($medicines)) { ?>
                                        <?php foreach ($medicines as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td>
                                                    <div class="avatar">
                                                        <?php if ($obj->photo) { ?>
                                                            <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>medicine-photo/<?php echo $obj->photo; ?>" alt="<?php echo $obj->medicine_name; ?>" />
                                                        <?php } else { ?>
                                                            <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>no-image.png" alt="no-image" />
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                                <td><?php echo $obj->category; ?></td>
                                                <td><?php echo $obj->manufacturer; ?></td>
                                                <td><?php echo $obj->medicine_name; ?></td>
                                                <td><?php echo $obj->mrp; ?></td>
                                                <td><?php echo $obj->purchase_price; ?></td>
                                                <td><?php echo $obj->sell_price; ?></td>
                                                <td><?php echo $obj->status ? '<span class="badge badge-primary">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                                                        <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'pharmacy', 'medicine')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('pharmacy/medicine/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'pharmacy', 'medicine')) { ?>
                                                        <a class="btn btn-xs btn-danger" href="<?php echo site_url('pharmacy/medicine/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="10"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('pharmacy/medicine/get_single_medicine'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>


<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
</script>