<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Refund.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Refund
 * @description     : Manage refund.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Refund extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Refund_Model', 'refund', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Refund List" user interface
     *
     * @param           : null
     * @refund          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_refund') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('refund/index', $this->data);
    }

    /*****************Function customer**********************************
     * @type            : Function
     * @function name   : customer
     * @description     : Load "Customer Refund List" user interface
     *
     * @param           : null
     * @refund          : null
     * ********************************************************** */
    public function customer() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('pharmacy/refund/customer/?keyword=' . $keyword . '&type=' . $type . '&date=' . $date . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->refund->get_customer_refund_invoice_list($config['per_page'], $offset, $keyword, $type, $form_date, $to_date, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['refunds'] = $this->refund->get_customer_refund_invoice_list($config['per_page'], $offset, $keyword, $type, $form_date, $to_date, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
        } else {
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->refund->get_customer_refund_invoice_list($config['per_page'], $offset, null, null, date('Y-m-d'), date('Y-m-d'), null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['refunds'] = $this->refund->get_customer_refund_invoice_list($config['per_page'], $offset, null, null, date('Y-m-d'), date('Y-m-d'), null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['employees'] = $this->refund->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('customer') . ' ' . $this->lang->line('refund') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('refund/customer/index', $this->data);
    }

    /*****************Function customer_search**********************************
     * @type            : Function
     * @function name   : customer_search
     * @description     : Load "Customer Refund Search" user interface
     *
     * @param           : null
     * @refund          : null
     * ********************************************************** */
    public function customer_search() {

        check_permission(VIEW);

        $invoice_no = $this->input->post('invoice_no');
        if (isset($invoice_no) && !empty($invoice_no)) {
            $invoice = $this->refund->get_single('medicine_invoices', array('custom_invoice_id' => $invoice_no, 'payment_status' => 'complete'));

            if ($invoice) {
                redirect('pharmacy/refund/customer_refund/' . $invoice->id . '/' . $invoice_no);
                success($this->lang->line('success'));
            } else {
                error($this->lang->line('no_data_found'));
                redirect('pharmacy/refund');
            }
        }
    }


    /*****************Function customer_refund**********************************
     * @type            : Function
     * @function name   : customer_refund
     * @description     : Load "Customer Refund Invoice" user interface
     *
     * @param           : null
     * @refund          : null
     * ********************************************************** */
    public function customer_refund() {

        check_permission(ADD);

        $this->data['invoice'] = $this->refund->get_single('medicine_invoices', array('id' => $this->uri->segment(4, 0), 'payment_status' => 'complete'));
        $this->data['customer'] = $this->refund->get_single('patients', array('user_id' => $this->data['invoice']->customer_id));
        $this->data['details'] = $this->refund->get_invoice_detail_list($this->uri->segment(4, 0));

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('refund') . ' ' . $this->lang->line('invoice') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('refund/customer/refund', $this->data);
    }

    /*****************Function add_customer_refund**********************************
     * @type            : Function
     * @function name   : add_customer_refund
     * @description     : Load "Add new Cutomer Refund" user interface
     *                    and process to store "refunds" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add_customer_refund() {

        check_permission(ADD);

        if ($_POST) {
            $data['custom_invoice_id'] = get_custom_id('medicine_refunds', 'INV-', date('Y'), date('m'));
            $data['invoice_type'] = 'refund';
            $data['sale_invoice_id'] = $this->input->post('invoice_id');
            $data['payment_type'] = $this->input->post('payment_type');
            $data['bill_date'] = date('Y-m-d H:i:s', strtotime($this->input->post('bill_date')));

            $data['total_bill'] = $this->input->post('total_bill');
            $data['total_refund'] = $this->input->post('total_refund');
            $data['net_payable'] = $this->input->post('total_refund');
            $data['advanced'] = $this->input->post('total_refund');
            $data['due_amount'] = 0;
            $data['paid_status'] = 'unpaid';
            if ($data['due_amount'] <= 0) {
                $data['paid_status'] = 'paid';
            }
            $data['payment_status'] = 'complete';
            $data['reason'] = $this->input->post('note');
            $data['return_type'] = 1;
            $data['status'] = 1;
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();

            $this->db->trans_start();
            $insert_id = $this->refund->insert('medicine_refunds', $data);

            // Insert Medicine Refund Details
            $return = $this->input->post('return');
            $medicine_id = $this->input->post('medicine_id');
            $batch_no = $this->input->post('batch_no');
            $sold_qty = $this->input->post('sold_qty');
            $quantity = $this->input->post('quantity');
            $rate = $this->input->post('rate');
            for ($i = 0, $n = count($return); $i < $n; $i++) {
                $medicinedata['invoice_id '] = $insert_id;
                $medicinedata['medicine_id'] = $medicine_id[$i];
                $medicinedata['batch_no'] = $batch_no[$i];
                $medicinedata['buy_qty'] = $sold_qty[$i];
                $medicinedata['quantity'] = $quantity[$i];
                $medicinedata['buy_rate'] = $rate[$i];
                $medicinedata['rate'] = $rate[$i];
                $medicinedata['buy_total_rate'] = ($medicinedata['buy_rate'] * $medicinedata['buy_qty']);
                $medicinedata['total_rate'] = ($medicinedata['rate'] * $medicinedata['quantity']);
                $medicinedata['status'] = 1;
                $medicinedata['created_at'] = date('Y-m-d H:i:s');
                $medicinedata['created_by'] = logged_in_user_id();

                $this->refund->insert('medicine_refund_details', $medicinedata);
            }
            // Medicine Refund Payment Data
            $paymentdata['invoice_id'] = $insert_id;
            $paymentdata['collection_type'] = '1';
            $paymentdata['payment_date'] = date('Y-m-d H:i:s', strtotime($this->input->post('bill_date')));
            $paymentdata['amount'] = $this->input->post('total_refund') ? $this->input->post('total_refund') : '0.00';
            $paymentdata['status'] = 1;
            $paymentdata['created_at'] = date('Y-m-d H:i:s');
            $paymentdata['created_by'] = logged_in_user_id();
            $this->refund->insert('medicine_refund_payments', $paymentdata);
            $this->db->trans_complete();

            if ($insert_id) {
                create_log('Has been created a medicine refund : ' . $insert_id);
                success($this->lang->line('insert_success'));
                redirect('pharmacy/refund/customer_invoice/' . $insert_id);
            } else {
                error($this->lang->line('insert_failed'));
                redirect('pharmacy/refund/customer_refund/' . $this->uri->segment(4, 0) . '/' . $this->uri->segment(5, 0));
            }
        }
    }

    /*****************Function customer_invoice**********************************
     * @type            : Function
     * @function name   : customer_invoice
     * @description     : Load "Customer Invoice List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function customer_invoice() {

        check_permission(VIEW);

        $this->data['invoice'] = $this->refund->get_single('medicine_refunds', array('id' => $this->uri->segment(4, 0)));
        $this->data['customer'] = $this->refund->get_single_customer($this->uri->segment(4, 0));
        $this->data['details'] = $this->refund->get_refund_medicine_invoice_list($this->uri->segment(4, 0));

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('refund') . ' ' . $this->lang->line('invoice') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/refund/customer/invoice', $this->data);
    }


    /*****************Function customer_invoice_print**********************************
     * @type            : Function
     * @function name   : customer_invoice_print
     * @description     : Load "Refund Invoice Print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function customer_invoice_print() {

        check_permission(VIEW);

        $this->load->library('Numbertowords');
        $this->data['invoice'] = $this->refund->get_single('medicine_refunds', array('id' => $this->uri->segment(4, 0)));
        $this->data['customer'] = $this->refund->get_single_customer($this->uri->segment(4, 0));
        $this->data['details'] = $this->refund->get_refund_medicine_invoice_list($this->uri->segment(4, 0));
        $this->load->view('pharmacy/refund/customer/print', $this->data);
    }
}
