<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('ipd'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                <a href="<?php echo site_url('ipd/new'); ?>" class="btn btn-primary btn-sm mr-15">
                    <i class="fa fa-user-plus"></i>
                    <?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('patient'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                <a href="<?php echo site_url('ipd/admitted'); ?>" class="btn btn-success btn-sm">
                    <i class="fa fa-users"></i>
                    <?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('patient'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'opd', 'opd')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-users font-30 mr-10"></i>
                            <?php echo $this->lang->line('existing'); ?> <?php echo $this->lang->line('patient'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('ipd/existing'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>" required>
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <?php if (isset($patients) && !empty($patients)) { ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('photo'); ?></th>
                                            <th><?php echo $this->lang->line('patient_id'); ?></th>
                                            <th><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('gender'); ?></th>
                                            <th><?php echo $this->lang->line('age'); ?></th>
                                            <th><?php echo $this->lang->line('phone'); ?></th>
                                            <th><?php echo $this->lang->line('address'); ?></th>
                                            <th class="w-10"><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (isset($patients) && !empty($patients)) { ?>
                                            <?php foreach ($patients as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $sl_count; ?></td>
                                                    <td>
                                                        <div class="avatar avatar-sm">
                                                            <?php if ($obj->photo) { ?>
                                                                <img src="<?php echo UPLOAD_PATH; ?>patient-photo/<?php echo $obj->photo; ?>" alt="user" class="avatar-img rounded-circle">
                                                            <?php } elseif ($obj->gender == 'male') { ?>
                                                                <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                                            <?php } else { ?>
                                                                <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                                                            <?php }  ?>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <td><?php echo $this->lang->line($obj->gender); ?></td>
                                                    <td><?php echo $obj->dob ? floor((time() - strtotime($obj->dob)) / 31556926) . 'Y' : ''; ?></td>
                                                    <td><?php echo $obj->phone; ?></td>
                                                    <td><?php echo $obj->address; ?></td>
                                                    <td>
                                                        <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                                                            <a class="btn btn-xs btn-success" href="<?php echo site_url('ipd/admission/' . $obj->user_id); ?>">
                                                                <i class="fa fa-plus"></i>
                                                                <?php echo $this->lang->line('admission'); ?>
                                                            </a>
                                                        <?php } ?>
                                                    </td>
                                                </tr>
                                                <?php $sl_count++; ?>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr class="text-center">
                                                <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->