<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Payment.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Payment
 * @description     : Manage IPD Payment Chart.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Payment extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Payment_Model', 'payment', true);
        $this->load->model('Ipd_Model', 'ipd', true);
        $this->load->library('Numbertowords');
    }

    public function set_barcode($code) {
        // Load library
        $this->load->library('zend');
        // Load in folder Zend
        $this->zend->load('Zend/Barcode');
        // Generate barcode
        Zend_Barcode::render('code128', 'image', array('text' => $code, 'drawText' => false), array());
    }

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);
        $this->data['total_investigation_due'] = $this->ipd->get_total_investigation_due($this->data['patient']->patient_id);
        $this->data['total_pharmacy_due'] = $this->ipd->get_total_pharmacy_due($this->data['patient']->patient_id);
        $this->data['total_ipd_advanced'] = $this->ipd->get_total_ipd_advaced($ipd_id, $this->data['patient']->patient_id);


        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('ipd/payment/index/' . $ipd_id . '/?search=' . $search);
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->payment->get_patient_payment_list($config['per_page'], $offset, $ipd_id, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['payments'] = $this->payment->get_patient_payment_list($config['per_page'], $offset, $ipd_id, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('payment') . ' ' . $this->lang->line('chart') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add Payment" user interface
     *                    and process to store "ipd_advance_payments" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('payment_date', $this->lang->line('payment') . ' ' . $this->lang->line('date'), 'trim|required');
            $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'trim|required');
            if ($this->form_validation->run() === TRUE) {
                $data['custom_invoice_id'] = get_custom_id('ipd_advance_payments', 'INV-', date('y'), date('m'));
                $data['ipd_id'] = $this->input->post('ipd_id');
                $data['patient_id'] = $this->input->post('patient_id');
                $data['amount'] = $this->input->post('amount');
                $data['payment_date'] = date('Y-m-d H:i', strtotime($this->input->post('payment_date')));
                $data['payment_status'] = 'complete';
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id = $this->payment->insert('ipd_advance_payments', $data);
                if ($insert_id) {
                    $patient = $this->payment->get_single('patients', array('user_id' => $data['patient_id']));

                    if (has_permission(ADD, 'ipd', 'ipd_payment_sms')) {
                        send_sms('ipd_payment', $insert_id);
                    }

                    create_log('Has been created a payment : ' . $patient->name);
                    success($this->lang->line('insert_success'));
                    redirect('ipd/payment/index/' . $data['ipd_id']);
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('ipd/payment/index/' . $data['ipd_id']);
                }
            } else {
                $this->data = $_POST;
            }
        }
    }

    /*****************Function get_payment**********************************
     * @type            : Function
     * @function name   : get_payment
     * @description     : Load "Single Payment" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_payment($id) {
        if ($id > 0) {
            $payment = $this->payment->get_single('ipd_advance_payments', array('id' => $id));
            echo (json_encode($payment));
        }
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Payment Chart" user interface
     *                    with populate "Payment Chart" value
     *                    and process to update "ipd_advance_payments" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit() {

        check_permission(EDIT);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('payment_date', $this->lang->line('payment') . ' ' . $this->lang->line('date'), 'trim|required');
            $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'trim|required');
            if ($this->form_validation->run() === TRUE) {
                $data['ipd_id'] = $this->input->post('ipd_id');
                $data['patient_id'] = $this->input->post('patient_id');
                $data['amount'] = $this->input->post('amount');
                $data['payment_date'] = date('Y-m-d H:i', strtotime($this->input->post('payment_date')));
                $data['payment_status'] = $this->input->post('payment_status');
                $data['note'] = $this->input->post('note');
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $this->payment->update('ipd_advance_payments', $data, array('id' => $this->input->post('id')));
                $patient = $this->payment->get_single('patients', array('user_id' => $this->input->post('patient_id')));

                if (has_permission(EDIT, 'ipd', 'ipd_payment_sms')) {
                    send_sms('ipd_payment', $this->input->post('id'));
                }

                create_log('Has been updated a payment : ' . $patient->name);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $msg = array(
                    'payment_date' => form_error('payment_date'),
                    'amount' => form_error('amount'),
                );
                $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
            }

            echo json_encode($array);
        }
    }

    /*     * ***************Function get_single_payment**********************************
     * @type            : Function
     * @function name   : get_single_payment
     * @description     : "Load single payment information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_payment() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->payment->get_single_payment($id);
        echo $this->load->view('ipd/payment/view', $this->data);
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Payment" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $payment = $this->payment->get_single('ipd_advance_payments', array('id' => $id));
        $patient = $this->payment->get_single('patients', array('user_id' => $payment->patient_id));

        if ($this->ipd->delete('ipd_advance_payments', array('id' => $id))) {
            create_log('Has been deleted a payment : ' . $patient->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function print() {
        $this->data['patient'] = $this->payment->get_print_list($this->input->post('id'));
        $this->load->view('ipd/payment/print', $this->data);
    }

    public function all_print() {
        $this->data['patient'] = $this->ipd->get_single_ipd_patient($this->input->post('ipd_id'));
        $this->data['invoices'] = $this->payment->get_list('ipd_advance_payments', array('payment_status' => 'complete', 'ipd_id' => $this->input->post('ipd_id'), 'patient_id' => $this->input->post('patient_id')));
        $this->load->view('ipd/payment/all-print', $this->data);
    }

    public function ipd_payment_sms($id = null) {
        check_permission(VIEW);
        if ($id) {
            send_sms('ipd_payment', $id);
        }
    }
}
