<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('patient'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_patient'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'patient', 'patient')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-circle-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('patient'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontoffice', 'appointment')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontoffice/appointment'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontoffice/appointment/addPatient/' . $appointment->id), array('name' => 'addPatient', 'id' => 'addPatient', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="name"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($appointment->name) ?  $appointment->name : ''; ?>" placeholder="<?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?>" autocomplete="off" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                            <select class="form-control custom-select" name="gender" id="gender" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $genders = get_genders(); ?>
                                <?php foreach ($genders as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($appointment->gender) && $appointment->gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('gender'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($appointment->phone) ?  $appointment->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" autocomplete="off" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="phone" class="form-text text-muted">
                                <?php echo form_error('phone'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="age"><?php echo $this->lang->line('age'); ?></label>
                            <input type="number" min="0" class="form-control" id="age" name="age" value="<?php echo isset($age) ?  $age : ''; ?>" placeholder="<?php echo $this->lang->line('age'); ?>" autocomplete="off">
                        </div>

                        <div class="col-md-1 mb-10">
                            <label for="month"><?php echo $this->lang->line('month'); ?></label>
                            <input type="number" min="1" max="12" class="form-control" id="month" name="month" value="<?php echo isset($month) ?  $month : ''; ?>" placeholder="<?php echo $this->lang->line('month'); ?>" autocomplete="off">
                        </div>

                        <div class="col-md-1 mb-10">
                            <label for="day"><?php echo $this->lang->line('day'); ?></label>
                            <input type="number" min="1" max="31" class="form-control" id="day" name="day" value="<?php echo isset($day) ?  $day : ''; ?>" placeholder="<?php echo $this->lang->line('day'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="address"><?php echo $this->lang->line('address'); ?></label>
                            <input type="text" class="form-control" name="address" id="address" value="<?php echo isset($appointment->address) ?  $appointment->address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="address" class="form-text text-muted">
                                <?php echo form_error('address'); ?>
                            </small>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="role_id" value="<?php echo PATIENT; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('patient'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<script>
    $("#age").on("change", function() {
        var age = parseInt(document.getElementById('age').value, 10);
        var today = new Date();
        var months = ["01", "02", "03", "04", "05", "06", "07",
            "08", "09", "10", "11", "12"
        ];
        var currentYear = today.getFullYear();
        var birthYear = currentYear - age;
        document.getElementById('dob').value = birthYear + '-' + months[today.getMonth()] + '-' + today.getDate();
    });
</script>

<script>
    $("#dob").daterangepicker({
        autoUpdateInput: false,
        startDate: false,
        minYear: 1901,
        showDropdowns: true,
        singleDatePicker: true,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
    $("#dob").on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });
</script>