<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Complaint_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_complaint_list($limit, $offset, $search, $count) {
        $this->db->select('C.*, CT.name as complaint_type, S.name as source');
        $this->db->from('complaints AS C');
        $this->db->join('complaint_types AS CT', 'CT.id = C.complaint_type_id', 'left');
        $this->db->join('sources AS S', 'S.id = C.source_id', 'left');
        if ($search) {
            $this->db->like('C.phone', $search);
            $this->db->or_like('C.name', $search);
            $this->db->or_like('C.action_date', $search);
            $this->db->or_like('C.complaint_date', $search);
            $this->db->or_like('C.description', $search);
            $this->db->or_like('C.note', $search);
            $this->db->or_like('CT.name', $search);
            $this->db->or_like('S.name', $search);
        }
        $this->db->order_by('C.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
    public function get_single_complaint($id) {
        $this->db->select('C.*, CT.name as complaint_type, S.name as source, CA.name as created_by, M.name as modified_by');
        $this->db->from('complaints AS C');
        $this->db->join('complaint_types AS CT', 'CT.id = C.complaint_type_id', 'left');
        $this->db->join('sources AS S', 'S.id = C.source_id', 'left');
        $this->db->join('employees AS CA', 'CA.user_id = C.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = C.modified_by', 'left');
        $this->db->where('C.id', $id);
        $this->db->order_by('C.id', 'DESC');
        return $this->db->get()->row();
    }
}
