<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************History.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Appointment History
 * @description     : Manage appointment history.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class History extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('History_Model', 'history', true);
        $this->load->model('Appointment_Model', 'appointment', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Appointment History List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index()
    {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(20);
            if ($date || $keyword) {
                $config['base_url'] = site_url('frontoffice/history/?keyword=' . $keyword . '&date=' . $date . '&created_by=' . $created_by);
            } else {
                $config['base_url'] = current_url();
            }
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->history->get_appointment_history_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['appointments'] = $this->history->get_appointment_history_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
        }
        $this->data['employees'] = $this->appointment->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('appointment') . ' ' . $this->lang->line('history') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('history/index', $this->data);
    }


    /*****************Function get_single_appointment_history**********************************
     * @type            : Function
     * @function name   : get_single_appointment_history
     * @description     : Load "Single Appointment History" user interface
     *                    and process to store "patients" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_single_appointment_history()
    {
        $id = $this->input->post('id');
        $this->data['appointment'] = $this->history->get_single_appointment_history($id);
        echo $this->load->view('history/view', $this->data);
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Appointment" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null)
    {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('frontoffice/history');
        }

        $appointment = $this->history->get_single('appointment_histories', array('id' => $id));

        if ($this->appointment->delete('appointment_histories', array('id' => $id))) {
            create_log('Has been deleted a Appointment history : ' . $appointment->id);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
