<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" data-toggle="tab" href="#tab_basic_info">
            <i class="fa fa-info-circle"></i> <?php echo $this->lang->line('basic'); ?> <?php echo $this->lang->line('information'); ?>
        </a>
    </li>
    <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
        <li class="nav-item">
            <a class="nav-link" data-toggle="tab" href="#tab_login_info">
                <i class="fa fa-key"></i> <?php echo $this->lang->line('login'); ?> <?php echo $this->lang->line('information'); ?>
            </a>
        </li>
    <?php } ?>
    <li class="nav-item">
        <a class="nav-link" data-toggle="tab" href="#tab_social_info">
            <i class="fa fa-share"></i> <?php echo $this->lang->line('social'); ?> <?php echo $this->lang->line('information'); ?>
        </a>
    </li>
</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div id="tab_basic_info" class="container tab-pane active">
        <div class="table-wrap">
            <div class="table-responsive">
                <table class="table table-sm mt-30 text-white">
                    <tbody>
                        <tr>
                            <td><?php echo $this->lang->line('name'); ?></td>
                            <td><?php echo $anesthetist->name; ?></td>
                            <td><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('name'); ?></td>
                            <td><?php echo $anesthetist->bn_name; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('type'); ?></td>
                            <td><?php echo $this->lang->line($anesthetist->commission_type); ?></td>
                            <td><?php echo $this->lang->line('bmdc_reg_no'); ?></td>
                            <td><?php echo $anesthetist->bmdc_reg_no; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('type'); ?></td>
                            <td><?php echo $this->lang->line($anesthetist->employee_type); ?></td>
                            <td><?php echo $this->lang->line('specialist'); ?></td>
                            <td><?php echo $anesthetist->specialist; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('department'); ?></td>
                            <td><?php echo $anesthetist->department; ?></td>
                            <td><?php echo $this->lang->line('designation'); ?></td>
                            <td><?php echo $anesthetist->designation; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('email'); ?></td>
                            <td><?php echo $anesthetist->email; ?></td>
                            <td><?php echo $this->lang->line('phone'); ?></td>
                            <td><?php echo $anesthetist->phone; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('gender'); ?></td>
                            <td><?php echo $this->lang->line($anesthetist->gender); ?></td>
                            <td><?php echo $this->lang->line('religion'); ?></td>
                            <td><?php echo $this->lang->line($anesthetist->religion); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('blood_group'); ?></td>
                            <td><?php echo $this->lang->line($anesthetist->blood_group); ?></td>
                            <td><?php echo $this->lang->line('marital_status'); ?></td>
                            <td><?php echo $this->lang->line($anesthetist->marital_status); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('birth_date'); ?></td>
                            <td><?php echo date($this->global_setting->date_format, strtotime($anesthetist->dob)); ?> (<?php echo $this->lang->line('age'); ?> : <?php echo $anesthetist->age; ?> <?php echo $this->lang->line('year'); ?>)</td>
                            <td><?php echo $this->lang->line('join_date'); ?></td>
                            <td><?php echo date($this->global_setting->date_format, strtotime($anesthetist->joining_date)); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('national_id'); ?></td>
                            <td colspan="3"><?php echo $anesthetist->national_id; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?></td>
                            <td><?php echo $anesthetist->present_address; ?></td>
                            <td><?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?></td>
                            <td><?php echo $anesthetist->permanent_address; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('status'); ?></td>
                            <td><?php echo $anesthetist->status ? $this->lang->line('active') : $this->lang->line('in_active'); ?></td>
                            <td><?php echo $this->lang->line('is_view_on_web'); ?></td>
                            <td><?php echo $anesthetist->is_view_on_web ? $this->lang->line('yes') : $this->lang->line('no'); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('photo'); ?></td>
                            <td>
                                <div class="avatar mr-10">
                                    <?php if ($anesthetist->photo) { ?>
                                        <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $anesthetist->photo; ?>" alt="<?php echo $anesthetist->name; ?>" />
                                    <?php } elseif ($anesthetist->gender == 'male') { ?>
                                        <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>male.png" alt="male" />
                                    <?php } else { ?>
                                        <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>female.png" alt="female" />
                                    <?php } ?>
                                </div>
                            </td>
                            <td><?php echo $this->lang->line('resume'); ?></td>
                            <td>
                                <?php if ($anesthetist->resume) { ?>
                                    <a target="_blank" href="<?php echo UPLOAD_PATH; ?>employee-resume/<?php echo $anesthetist->resume; ?>" class="btn btn-success btn-xs"><i class="fa fa-download"></i> <?php echo $this->lang->line('download'); ?></a>
                                <?php } ?>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('created_by'); ?></td>
                            <td><?php echo $anesthetist->created_by; ?></td>
                            <td><?php echo $this->lang->line('date'); ?></td>
                            <td><?php echo $anesthetist->created_by ? date('d F, Y h:i A', strtotime($anesthetist->created_at)) : ''; ?>
                            </td>
                        </tr>
                        <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
                            <tr>
                                <td><?php echo $this->lang->line('modified_by'); ?></td>
                                <td><?php echo $anesthetist->modified_by; ?></td>
                                <td><?php echo $this->lang->line('date'); ?></td>
                                <td><?php echo $anesthetist->modified_by ? date('d F, Y h:i A', strtotime($anesthetist->modified_at)) : ''; ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- Basic Info End -->
    <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
        <div id="tab_login_info" class="container tab-pane fade">
            <div class="table-wrap">
                <div class="table-responsive">
                    <table class="table table-sm mt-30 text-white">
                        <tbody>
                            <tr>
                                <td><?php echo $this->lang->line('username'); ?></td>
                                <td><?php echo $anesthetist->username; ?></td>
                                <td><?php echo $this->lang->line('password'); ?></td>
                                <td><?php echo base64_decode($anesthetist->temp_password); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo $this->lang->line('device_id'); ?></td>
                                <td><?php echo $anesthetist->device_id; ?></td>
                                <td><?php echo $this->lang->line('sbiz_id'); ?></td>
                                <td><?php echo $anesthetist->sbiz_id; ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php } ?>
    <!-- Login Info End -->
    <div id="tab_social_info" class="container tab-pane fade">
        <div class="table-wrap">
            <div class="table-responsive">
                <table class="table table-sm mt-30 text-white">
                    <tbody>
                        <tr>
                            <td><?php echo $this->lang->line('facebook_url'); ?></td>
                            <td><?php echo $anesthetist->facebook_url; ?></td>
                            <td><?php echo $this->lang->line('instagram_url'); ?></td>
                            <td><?php echo $anesthetist->instagram_url; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('twitter_url'); ?></td>
                            <td><?php echo $anesthetist->twitter_url; ?></td>
                            <td><?php echo $this->lang->line('linkedin_url'); ?></td>
                            <td><?php echo $anesthetist->linkedin_url; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('youtube_url'); ?></td>
                            <td><?php echo $anesthetist->youtube_url; ?></td>
                            <td><?php echo $this->lang->line('pinterest_url'); ?></td>
                            <td><?php echo $anesthetist->pinterest_url; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('tubblr_url'); ?></td>
                            <td><?php echo $anesthetist->tubblr_url; ?></td>
                            <td><?php echo $this->lang->line('skype'); ?></td>
                            <td><?php echo $anesthetist->skype; ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- Social Info End -->
</div>