<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Template_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_template_list($limit = null, $offset = null, $search = null, $test_id = null, $count = false) {
        
        $this->db->select('t.*, d.name as department, g.name as group, dt.name as test_name');
        $this->db->distinct();
        $this->db->from('diagnostic_tests_template t');
        $this->db->join('diagnostic_departments d', 'd.id = t.department_id', 'left');
        $this->db->join('diagnostic_groups g', 'g.id = t.group_id', 'left');
        $this->db->join('diagnostic_tests dt', 'dt.id = t.test_id', 'left');
        
        if ($search) {
            $this->db->like('t.investigation', $search);
        }
        
        if ($test_id) {
            $this->db->where('t.test_id', $test_id);
        }
        
        $this->db->where('t.status', 1);
        $this->db->order_by('t.id', 'DESC');
        
        if ($count) {
            return $this->db->count_all_results();
        }
        
        if ($limit) {
            $this->db->limit($limit, $offset);
        }
        
        return $this->db->get()->result();
    }

    public function get_single_template($id) {
        $this->db->select('DT.*, D.name as department, G.name as group, T.name as test_name');
        $this->db->from('diagnostic_tests_template AS DT');
        $this->db->join('diagnostic_departments AS D', 'D.id = DT.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = DT.group_id', 'left');
        $this->db->join('diagnostic_tests AS T', 'T.id = DT.test_id', 'left');
        $this->db->where('DT.id', $id);
        return $this->db->get()->row();
    }

    public function get_option_list() {
        $this->db->select('O.*, T.name as test_name, DT.investigation as template_name');
        $this->db->from('diagnostic_tests_option AS O');
        $this->db->join('diagnostic_tests AS T', 'T.id = O.test_id', 'left');
        $this->db->join('diagnostic_tests_template AS DT', 'DT.id = O.template_id', 'left');
        $this->db->order_by('O.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_unit_list() {
        $this->db->select('*');
        $this->db->from('diagnostic_tests_unit');
        $this->db->order_by('id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_single_unit($id) {
        $this->db->select('*');
        $this->db->from('diagnostic_tests_unit');
        $this->db->where('id', $id);
        return $this->db->get()->row();
    }

    public function duplicate_check($field, $value, $table, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where($field, $value);
        return $this->db->get($table)->num_rows();
    }

    public function update($table, $data, $where) {
        // Debug information
        log_message('debug', 'Update Method - Table: ' . $table);
        log_message('debug', 'Update Method - Data: ' . json_encode($data));
        log_message('debug', 'Update Method - Where: ' . json_encode($where));
        
        $this->db->where($where);
        $result = $this->db->update($table, $data);
        
        if (!$result) {
            log_message('error', 'Database Error: ' . $this->db->error()['message']);
            log_message('error', 'Last Query: ' . $this->db->last_query());
        }
        
        return $result;
    }
}
