<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('attendance'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_attendance'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('attendance/manual'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('designation'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($designation_id) && $designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="user_id"><?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="user_id" id="user_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($user_id) && $user_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="shift_id"><?php echo $this->lang->line('shift'); ?></label>
                            <select class="form-control custom-select select2" name="shift_id" id="shift_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('shift'); ?></option>
                                <?php foreach ($shifts as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($shift_id) && $shift_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        <?php if (isset($attendances) && !empty($attendances)) { ?>
            <!-- col-xl-12 -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'attendance', 'attendance')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-clock-o font-30 mr-10"></i>
                                <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('list'); ?>
                            </h6>
                        <?php } ?>
                    </div>
                    <?php echo form_open_multipart(site_url('attendance/manual_attendance'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('device_id'); ?></th>
                                            <th class="w-20"><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('designation'); ?></th>
                                            <th class="w-15"><?php echo $this->lang->line('shift'); ?></th>
                                            <th class="w-10"><?php echo $this->lang->line('date'); ?></th>
                                            <th class="w-10"><?php echo $this->lang->line('clock_in'); ?></th>
                                            <th class="w-10"><?php echo $this->lang->line('clock_out'); ?></th>
                                            <th class="w-10"><?php echo $this->lang->line('status'); ?></th>
                                            <th class="w-10"><?php echo $this->lang->line('remark'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($attendances as $obj) {
                                            $attendance = $this->attendance->get_single('attendances', array('user_id' => $obj->user_id, 'date' => $date));
                                        ?>
                                            <tr>
                                                <td><?php echo $obj->device_id; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->designation; ?></td>
                                                <td>
                                                    <?php echo $obj->shift; ?><br />
                                                    <strong>In:</strong><?php echo date('h:ia', strtotime($obj->in_time)); ?><br />
                                                    <strong>Out:</strong><?php echo date('h:ia', strtotime($obj->out_time)); ?>
                                                </td>
                                                <td><?php echo date('M d, Y', strtotime($date)); ?></td>
                                                <td>
                                                    <input type="hidden" name="employee_id[]" value="<?php echo $obj->user_id; ?>">
                                                    <input type="hidden" name="shift_id[<?php echo $obj->user_id; ?>]" value="<?php echo $obj->shift_id; ?>">
                                                    <input type="hidden" name="date[<?php echo $obj->user_id; ?>]" value="<?php echo $date; ?>">
                                                    <input type="text" class="form-control form-control-sm time" id="clock_in" name="clock_in[<?php echo $obj->user_id; ?>]" value="<?php echo isset($attendance) && !empty($attendance) ? $attendance->clock_in : ''; ?>" placeholder="<?php echo $this->lang->line('clock_in'); ?>">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm time" id="clock_out" name="clock_out[<?php echo $obj->user_id; ?>]" value="<?php echo isset($attendance) && !empty($attendance) ? $attendance->clock_out : ''; ?>" placeholder="<?php echo $this->lang->line('clock_out'); ?>">
                                                </td>
                                                <td>
                                                    <select class="form-control form-control-sm" name="attendance_status[<?php echo $obj->user_id; ?>]" id="attendance_status" required>
                                                        <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                                        <?php $status = get_attendance_status(); ?>
                                                        <?php foreach ($status as $key => $value) { ?>
                                                            <option value="<?php echo $key; ?>" <?php echo isset($attendance->attendance_status) && $attendance->attendance_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="remark" name="remark[<?php echo $obj->user_id; ?>]" value="<?php echo isset($attendance) && !empty($attendance) ? $attendance->remark : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <div class="card-footer pt-0">
                        <div class="button-list">
                            <a class="btn btn-gradient-danger" href="<?php echo site_url('attendance'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                            <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#date').daterangepicker({
        minYear: 1901,
        showDropdowns: true,
        singleDatePicker: true,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
</script>

<script>
    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>


<!-- Time Picker -->
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.css" rel="stylesheet" type="text/css" />
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker-theme.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.js"></script>

<script>
    $('.time').mdtimepicker({
        timeFormat: 'hh:mm:ss.000',
        format: 'h:mm tt',
        // theme of the timepicker
        // 'red', 'purple', 'indigo', 'teal', 'green', 'dark'
        theme: 'teal',
        readOnly: false,
        hourPadding: false,
        clearBtn: true
    });
</script>