<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Exphead_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_exphead_list($limit, $offset, $search, $count) {
        $this->db->select('EH.*');
        $this->db->from('expenditure_heads AS EH');
        if ($search) {
            $this->db->like('EH.name', $search);
            $this->db->or_like('EH.bn_name', $search);
            $this->db->or_like('EH.note', $search);
        }
        $this->db->order_by('EH.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }


    function duplicate_check($name, $id = null) {

        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('expenditure_heads')->num_rows();
    }
}
