<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

//  Admin Route
$route['admin'] = 'welcome';
$route['forgot'] = 'auth/forgot';
$route['reset/(:any)'] = 'auth/reset/$1';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;


// Forntend Route
$route['default_controller'] = 'web';
$route['language/(:any)'] = 'auth/language/$1';
$route['page/(:num)/(:any)'] = 'web/page/$1';
$route['appointment_doctor'] = 'web/appointment_doctor';
$route['search_patient/(:num)'] = 'web/search_patient/$1';
$route['appointment'] = 'web/appointment';
$route['appointment/success/(:num)'] = 'web/appointment_success/$1';
$route['appointment/print'] = 'web/appointment_print';
$route['appointment/pdf/(:num)'] = 'web/appointment_pdf/$1';
$route['doctors'] = 'web/doctors';
$route['doctor/(:num)'] = 'web/doctor/$1';
$route['departments'] = 'web/departments';
$route['department/doctor/(:num)'] = 'web/department_doctor/$1';
$route['services'] = 'web/services';
$route['service/(:num)/(:any)'] = 'web/service/$1/$1';
$route['news'] = 'web/news';
$route['news/(:num)/(:any)'] = 'web/news_single/$1/$1';
$route['photos'] = 'web/photos';
$route['photos/gallery/(:num)'] = 'web/photo_gallery/$1';
$route['videos'] = 'web/videos';
$route['videos/gallery/(:num)'] = 'web/video_gallery/$1';
$route['contact'] = 'web/contact';
