<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('normal_value'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('normal_value'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('diagnostic/template/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'diagnostic', 'template')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-flask font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('normal_value'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'diagnostic', 'template')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('diagnostic/template'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('normal_value'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('diagnostic/template/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('investigation'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" required onchange="get_test(this.value)">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="group_id"><?php echo $this->lang->line('group'); ?> <?php echo $this->lang->line('investigation'); ?></label>
                            <select class="form-control custom-select" name="group_id" id="group_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="test_id"><?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('investigation'); ?></label>
                            <select class="form-control custom-select select2" name="test_id" id="test_id" required>
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="investigation"><?php echo $this->lang->line('investigation'); ?></label>
                            <input type="text" class="form-control" name="investigation" id="investigation" value="<?php echo isset($investigation) ?  $investigation : ''; ?>" placeholder="<?php echo $this->lang->line('investigation'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="investigation" class="form-text text-muted">
                                <?php echo form_error('investigation'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="unit_id"><?php echo $this->lang->line('unit'); ?></label>
                            <select class="form-control custom-select select2" name="unit_id" id="unit_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php if(isset($units)): ?>
                                    <?php foreach($units as $unit): ?>
                                        <option value="<?php echo $unit->id; ?>" <?php echo isset($unit_id) && $unit_id == $unit->id ? 'selected="selected"' : ''; ?>><?php echo $unit->unit_name; ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($sort_by) ?  $sort_by : '0'; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="sort_by" class="form-text text-muted">
                                <?php echo form_error('sort_by'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <label for="normal_value"><?php echo $this->lang->line('normal_value'); ?></label>
                            <div class="tinymce-wrap">
                                <textarea class="tinymce" name="normal_value" id="normal_value" placeholder="<?php echo $this->lang->line('normal_value'); ?>"><?php echo isset($normal_value) ?  $normal_value : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('diagnostic/template'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Tinymce JavaScript -->
<script src="<?php echo VENDOR_URL; ?>tinymce/tinymce.min.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $(function() {
        "use strict";
        tinymce.init({
            selector: '.tinymce',
            height: 150,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table contextmenu paste code'
            ],
            toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',

        });
    });
</script>

<script>
    function get_test(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_diagnostic_test'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#test_id').html(response);
                }
            }
        });
    };
</script>
<script>
    $('#department_id').on("change", function(){
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_diagnostic_group'); ?>",
            data: {
                department_id:  $('#department_id').val()
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#group_id').html(response);
                }
            }
        });
    });
</script>