<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <div class="col-xl-12 pa-0">
            <!-- Profile Heading -->
            <?php $this->load->view('profile/header'); ?>
            <!-- Profile Body -->
            <!-- Container -->
            <div class="container mt-50">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h6 class="card-header d-flex align-items-center">
                                    <i class="fa fa-camera font-30 mr-10"></i>
                                    <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('profile'); ?> <?php echo $this->lang->line('photo'); ?>
                                </h6>
                                <div class="align-items-center">
                                    <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                                        <i class="fa fa-dashboard font-12 mr-5"></i>
                                        <?php echo $this->lang->line('dashboard'); ?>
                                    </a>
                                </div>
                            </div>
                            <?php echo form_open_multipart(site_url('profile/photo'), array('name' => 'photo', 'id' => 'photo', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-9 mb-20">
                                        <label for="photo"><?php echo $this->lang->line('photo'); ?></label>
                                        <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                            </div>
                                            <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                            <span class="input-group-append">
                                                <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                                    <input type="file" name="photo">
                                                    <input type="hidden" name="prev_photo" id="prev_photo" value="<?php echo $profile->photo; ?>" />
                                                </span>
                                                <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                            </span>
                                        </div>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-20">
                                        <div class="avatar">
                                            <?php if ($profile->photo != '') { ?>
                                                <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $profile->photo; ?>" alt="<?php echo $profile->name; ?>" />
                                            <?php } elseif ($profile->gender == 'male') { ?>
                                                <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>male.png" alt="male" />
                                            <?php } else { ?>
                                                <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>female.png" alt="female" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="col-md-9 mb-20">
                                        <label for="cover"><?php echo $this->lang->line('cover'); ?> <?php echo $this->lang->line('photo'); ?></label>
                                        <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                            </div>
                                            <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                            <span class="input-group-append">
                                                <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                                    <input type="file" name="cover">
                                                    <input type="hidden" name="prev_cover" id="prev_cover" value="<?php echo $profile->cover; ?>" />
                                                </span>
                                                <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                            </span>
                                        </div>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-20">
                                        <div class="avatar">
                                            <?php if ($profile->cover != '') { ?>
                                                <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-cover/<?php echo $profile->cover; ?>" alt="<?php echo $profile->name; ?>" />
                                            <?php } else { ?>
                                                <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>bg/cover.jpg" alt="cover" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="col-md-9 mb-20">
                                        <label for="signature"><?php echo $this->lang->line('signature'); ?></label>
                                        <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                            </div>
                                            <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                            <span class="input-group-append">
                                                <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                                    <input type="file" name="signature">
                                                    <input type="hidden" name="prev_signature" id="prev_signature" value="<?php echo $profile->signature; ?>" />
                                                </span>
                                                <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                            </span>
                                        </div>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-20">
                                        <div class="avatar">
                                            <?php if ($profile->signature != '') { ?>
                                                <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-signature/<?php echo $profile->signature; ?>" alt="<?php echo $profile->name; ?>" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="col-md-9 mb-20">
                                        <label for="resume"><?php echo $this->lang->line('resume'); ?></label>
                                        <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                            </div>
                                            <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                            <span class="input-group-append">
                                                <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                                    <input type="file" name="resume">
                                                    <input type="hidden" name="prev_resume" id="prev_resume" value="<?php echo $profile->resume; ?>" />
                                                </span>
                                                <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                            </span>
                                        </div>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-20">
                                        <div class="avatar mt-40 ml-10">
                                            <?php if ($profile->resume != '') { ?>
                                                <a href="<?php echo UPLOAD_PATH; ?>employee-resume/<?php echo $profile->resume; ?>"><i class="fa fa-download" aria-hidden="true"></i> <?php echo $this->lang->line('download'); ?></a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Card Footer -->
                            <div class="card-footer pt-0">
                                <div class="button-list">
                                    <a class="btn btn-gradient-danger" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                                </div>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
                <!-- /Row -->
            </div>
            <!-- /Container -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->