<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <div class="col-xl-12 pa-0">
            <!-- Profile Heading -->
            <?php $this->load->view('profile/header'); ?>
            <!-- Profile Body -->
            <!-- Container -->
            <div class="container mt-50">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h6 class="card-header d-flex align-items-center">
                                    <i class="fa fa-user font-30 mr-10"></i>
                                    <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('profile'); ?>
                                </h6>
                                <div class="align-items-center">
                                    <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                                        <i class="fa fa-dashboard font-12 mr-5"></i>
                                        <?php echo $this->lang->line('dashboard'); ?>
                                    </a>
                                </div>
                            </div>

                            <?php echo form_open_multipart(site_url('profile'), array('name' => 'profile', 'id' => 'profile', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-4 mb-10">
                                        <label for="name"><?php echo $this->lang->line('name'); ?></label>
                                        <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($profile->name) ?  $profile->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                        <small id="name" class="form-text text-muted">
                                            <?php echo form_error('name'); ?>
                                        </small>
                                    </div>
                                    <div class="col-md-4 mb-10">
                                        <label for="bn_name"><?php echo $this->lang->line('bn_name'); ?></label>
                                        <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($profile->bn_name) ?  $profile->bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('bn_name'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                        <small id="name" class="form-text text-muted">
                                            <?php echo form_error('bn_name'); ?>
                                        </small>
                                    </div>
                                    <div class="col-md-4 mb-10">
                                        <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                                        <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($profile->phone) ?  $profile->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                        <small id="name" class="form-text text-muted">
                                            <?php echo form_error('phone'); ?>
                                        </small>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="national_id"><?php echo $this->lang->line('national_id'); ?></label>
                                        <input type="number" class="form-control" name="national_id" id="national_id" value="<?php echo isset($profile->national_id) ?  $profile->national_id : ''; ?>" placeholder="<?php echo $this->lang->line('national_id'); ?>">
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="birth_date"><?php echo $this->lang->line('birth_date'); ?></label>
                                        <input type="text" class="form-control" name="dob" id="dob" value="<?php echo isset($profile->dob) ?  date('d/m/Y', strtotime($profile->dob)) : ''; ?>" placeholder="<?php echo $this->lang->line('birth_date'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                        <small id="name" class="form-text text-muted">
                                            <?php echo form_error('birth_date'); ?>
                                        </small>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                                        <select class="form-control custom-select" name="gender" id="gender" required>
                                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php $genders = get_genders(); ?>
                                            <?php foreach ($genders as $key => $value) { ?>
                                                <option value="<?php echo $key; ?>" <?php echo isset($profile->gender) && $profile->gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                        <small id="name" class="form-text text-muted">
                                            <?php echo form_error('gender'); ?>
                                        </small>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="religion"><?php echo $this->lang->line('religion'); ?></label>
                                        <select class="form-control custom-select" name="religion" id="religion" required>
                                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php $religions = get_religion(); ?>
                                            <?php foreach ($religions as $key => $value) { ?>
                                                <option value="<?php echo $key; ?>" <?php echo isset($profile->religion) && $profile->religion == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                        <small id="name" class="form-text text-muted">
                                            <?php echo form_error('religion'); ?>
                                        </small>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="blood_group"><?php echo $this->lang->line('blood_group'); ?></label>
                                        <select class="form-control custom-select" name="blood_group" id="blood_group">
                                            <option selected><?php echo $this->lang->line('select'); ?></option>
                                            <?php $bloods = get_blood_group(); ?>
                                            <?php foreach ($bloods as $key => $value) { ?>
                                                <option value="<?php echo $key; ?>" <?php echo isset($profile->blood_group) && $profile->blood_group == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="marital_status"><?php echo $this->lang->line('marital_status'); ?></label>
                                        <select class="form-control custom-select" name="marital_status" id="marital_status">
                                            <option selected><?php echo $this->lang->line('select'); ?></option>
                                            <?php $marital_status = get_marital_status(); ?>
                                            <?php foreach ($marital_status as $key => $value) { ?>
                                                <option value="<?php echo $key; ?>" <?php echo isset($profile->marital_status) && $profile->marital_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="email"><?php echo $this->lang->line('email'); ?></label>
                                        <input type="text" class="form-control" name="email" id="email" value="<?php echo isset($profile->email) ?  $profile->email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>">
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="username"><?php echo $this->lang->line('username'); ?></label>
                                        <input type="text" class="form-control" name="username" id="username" value="<?php echo isset($profile->username) ?  $profile->username : ''; ?>" placeholder="<?php echo $this->lang->line('username'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                        <small id="name" class="form-text text-muted">
                                            <?php echo form_error('username'); ?>
                                        </small>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="father_name"><?php echo $this->lang->line('father_name'); ?></label>
                                        <input type="text" class="form-control" name="father_name" id="father_name" value="<?php echo isset($profile->father_name) ?  $profile->father_name : ''; ?>" placeholder="<?php echo $this->lang->line('father_name'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="father_bn_name"><?php echo $this->lang->line('father_bn_name'); ?></label>
                                        <input type="text" class="form-control" name="father_bn_name" id="father_bn_name" value="<?php echo isset($profile->father_bn_name) ?  $profile->father_bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('father_bn_name'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="mother_name"><?php echo $this->lang->line('mother_name'); ?></label>
                                        <input type="text" class="form-control" name="mother_name" id="mother_name" value="<?php echo isset($profile->mother_name) ?  $profile->mother_name : ''; ?>" placeholder="<?php echo $this->lang->line('mother_name'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-10">
                                        <label for="mother_bn_name"><?php echo $this->lang->line('mother_bn_name'); ?></label>
                                        <input type="text" class="form-control" name="mother_bn_name" id="mother_bn_name" value="<?php echo isset($profile->mother_bn_name) ?  $profile->mother_bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('mother_bn_name'); ?>" required>
                                        <div class="valid-feedback">
                                            <?php echo $this->lang->line('looks_good'); ?>
                                        </div>
                                        <div class="invalid-feedback">
                                            <?php echo $this->lang->line('required_field'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mt-10 mb-10">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?></span>
                                            </div>
                                            <textarea class="form-control" name="present_address" id="present_address" aria-label="<?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($profile->present_address) ?  $profile->present_address : ''; ?></textarea>
                                            <div class="valid-feedback">
                                                <?php echo $this->lang->line('looks_good'); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mt-10 mb-10">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?></span>
                                            </div>
                                            <textarea class="form-control" name="permanent_address" id="permanent_address" aria-label="<?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($profile->permanent_address) ?  $profile->permanent_address : ''; ?></textarea>
                                            <div class="valid-feedback">
                                                <?php echo $this->lang->line('looks_good'); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 mt-10 mb-10">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><?php echo $this->lang->line('about'); ?></span>
                                            </div>
                                            <textarea class="form-control" name="about" id="about" aria-label="<?php echo $this->lang->line('about'); ?>"><?php echo isset($profile->about) ?  $profile->about : ''; ?></textarea>
                                            <div class="valid-feedback">
                                                <?php echo $this->lang->line('looks_good'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Card Footer -->
                            <div class="card-footer pt-0">
                                <div class="button-list">
                                    <a class="btn btn-gradient-danger" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                                </div>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
                <!-- /Row -->
            </div>
            <!-- /Container -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->