<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('notification'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_notification'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'setting', 'notification')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('notification'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(ADD, 'setting', 'notification')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/notification/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('notification'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <?php echo form_open_multipart(site_url('setting/notification'), array('name' => 'notification', 'id' => 'notification', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0 mt-30">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('type'); ?></th>
                                        <th><?php echo $this->lang->line('email'); ?></th>
                                        <th><?php echo $this->lang->line('sms'); ?></th>
                                        <th><?php echo $this->lang->line('message'); ?> </th>
                                        <th><?php echo $this->lang->line('action'); ?> </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1;
                                    if (isset($notifications) && !empty($notifications)) {
                                    ?>
                                        <?php foreach ($notifications as $key => $obj) { ?>
                                            <tr>
                                                <td><?php echo $count++;  ?></td>
                                                <td>
                                                    <?php echo $obj->type; ?>
                                                    <input type="hidden" name="notification[]" value="<?php echo $obj->id; ?>">
                                                </td>
                                                <td>
                                                    <div class="custom-control custom-checkbox checkbox-primary">
                                                        <input type="checkbox" class="custom-control-input" name="is_email_<?php echo $obj->id; ?>" id="is_email_<?php echo $obj->id; ?>" value="1" <?php echo $obj->is_email ? 'checked' : ''; ?>>
                                                        <label class="custom-control-label" for="is_email_<?php echo $obj->id; ?>"><?php echo $obj->is_email ? $this->lang->line('active') : $this->lang->line('in_active'); ?></label>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="custom-control custom-checkbox checkbox-primary">
                                                        <input type="checkbox" class="custom-control-input" name="is_sms_<?php echo $obj->id; ?>" id="is_sms_<?php echo $obj->id; ?>" value="1" <?php echo $obj->is_sms ? 'checked' : ''; ?>>
                                                        <label class="custom-control-label" for="is_sms_<?php echo $obj->id; ?>"><?php echo $obj->is_sms ? $this->lang->line('active') : $this->lang->line('in_active'); ?></label>
                                                    </div>
                                                </td>
                                                <td><?php echo $obj->message; ?></td>
                                                <td>
                                                    <?php if (has_permission(EDIT, 'setting', 'notification')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('setting/notification/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'setting', 'notification')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('setting/notification/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->