<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('custom'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('custom'); ?> <?php echo $this->lang->line('permission'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'setting', 'custom')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-key font-30 mr-10"></i>
                            <?php echo $this->lang->line('permission'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('setting/custom'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                    <?php if (has_permission(ADD, 'setting', 'custom')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/custom/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('permission'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('permission'); ?> <?php echo $this->lang->line('type'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th><?php echo $this->lang->line('note'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($permissions) && !empty($permissions)) { ?>
                                        <?php foreach ($permissions as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $this->lang->line($obj->permission_type); ?></td>
                                                <td><?php echo $obj->permissions_status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?></td>
                                                <td><?php echo $obj->note; ?></td>
                                                <td>
                                                    <?php if (has_permission(EDIT, 'setting', 'custom')) { ?>
                                                        <a class="btn btn-success btn-xs" href="<?php echo site_url('setting/custom/edit/' . $obj->id); ?>"> <i class="fa fa-pencil"></i> </a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'setting', 'custom')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('setting/custom/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->