<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Setting_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_user_list($limit, $offset, $role_id, $user_id, $count) {
        if ($role_id == SUPER_ADMIN) {
            $this->db->select('E.*, U.username, U.temp_password, U.role_id, U.status');
            $this->db->from('employees AS E');
            $this->db->join('users AS U', 'U.id = E.user_id', 'left');
            if ($user_id) {
                $this->db->where('E.user_id', $user_id);
            }
            $this->db->where('U.role_id', $role_id);
            $this->db->order_by('E.id', 'ASC');
            if ($count) {
                return $this->db->count_all_results();
            } else {
                $this->db->limit($limit, $offset);
                $query = $this->db->get();

                if ($query->num_rows() > 0) {
                    return $query->result();
                }
            }
            return array();
        } else {
            $this->db->select('E.*, U.username, U.temp_password, U.role_id, U.status');
            $this->db->from('employees AS E');
            $this->db->join('users AS U', 'U.id = E.user_id', 'left');
            if ($user_id) {
                $this->db->where('E.user_id', $user_id);
            }
            $this->db->where('U.role_id', $role_id);
            $this->db->order_by('E.id', 'ASC');
            if ($count) {
                return $this->db->count_all_results();
            } else {
                $this->db->limit($limit, $offset);
                $query = $this->db->get();

                if ($query->num_rows() > 0) {
                    return $query->result();
                }
            }
            return array();
        }
    }

    public function get_module_list($limit, $offset, $search, $count) {
        $this->db->select('M.*');
        $this->db->from('modules AS M');
        if ($search) {
            $this->db->like('M.module_name', $search);
            $this->db->or_like('M.module_slug', $search);
        }
        $this->db->order_by('M.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_operation_list($limit, $offset, $search, $count) {
        $this->db->select('O.*, M.module_name');
        $this->db->from('operations AS O');
        $this->db->join('modules AS M', 'M.id = O.module_id', 'left');
        if ($search) {
            $this->db->like('O.operation_name', $search);
            $this->db->or_like('O.operation_slug', $search);
            $this->db->or_like('O.is_view_vissible', $search);
            $this->db->or_like('O.created_at', $search);
            $this->db->or_like('M.module_name', $search);
        }
        $this->db->order_by('O.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_sms_template_list($limit, $offset, $search, $count) {
        $this->db->select('T.*, R.name as user_role');
        $this->db->from('sms_templates AS T');
        $this->db->join('roles AS R', 'R.id = T.role_id', 'left');
        if ($search) {
            $this->db->like('T.title', $search);
            $this->db->or_like('T.template', $search);
            $this->db->or_like('T.created_at', $search);
            $this->db->or_like('R.name', $search);
        }
        $this->db->order_by('T.id', 'ASC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_email($email, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('email', $email);
        return $this->db->get('employees')->num_rows();
    }

    function duplicate_check_notification_type($type, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('type', $type);
        return $this->db->get('notifications')->num_rows();
    }

    function duplicate_check_sms_template($type, $role_id, $id = null) {

        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('type', $type);
        $this->db->where('role_id', $role_id);
        return $this->db->get('sms_templates')->num_rows();
    }

    public function get_activity_log($limit, $offset, $role_id, $user_id, $form_date, $to_date, $keyword, $count) {
        $this->db->select('AL.*');
        $this->db->from('activity_logs AS AL');
        if ($role_id) {
            $this->db->where('AL.role_id', $role_id);
        }
        if ($user_id) {
            $this->db->where('AL.user_id', $user_id);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(AL.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($keyword) {
            $this->db->like('AL.phone', $keyword);
            $this->db->or_like('AL.name', $keyword, 'both');
            $this->db->or_like('AL.activity', $keyword, 'both');
        }
        $this->db->order_by('AL.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_backup_list($limit, $offset, $search, $count) {
        $this->db->select('B.*');
        $this->db->from('backups AS B');
        if ($search) {
            $this->db->like('B.name', $search);
            $this->db->or_like('B.location', $search);
            $this->db->or_like('B.created_at', $search);
        }
        $this->db->order_by('B.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
    
    public function get_custom_permission_list($limit, $offset, $search, $count) {
        $this->db->select('P.*, E.name, E.phone');
        $this->db->from('permissions AS P');
        $this->db->join('employees AS E', 'E.user_id = P.user_id', 'left');
        if ($search) {
            $this->db->like('P.permissions_status', $search);
            $this->db->or_like('P.permission_type', $search, 'both');
            $this->db->or_like('E.name', $search, 'both');
            $this->db->or_like('E.phone', $search, 'both');
        }
        $this->db->order_by('P.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_custom_permission($role_id, $user_id, $type, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('role_id', $role_id);
        $this->db->where('user_id', $user_id);
        $this->db->where('permission_type', $type);
        return $this->db->get('permissions')->num_rows();
    }
}
