<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Password.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Password
 * @description     : Reset users password by System setting.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : http://hms.sbitzone.com    
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team	
 * ********************************************************** */

class Password extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }

    /*     * ***************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load reset password user interface                 
     *                    and reset user password processing    
     * @param           : $id integer value
     * @return          : null 
     * ********************************************************** */

    public function index() {

        check_permission(EDIT);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('role_id', $this->lang->line('user') . ' ' . $this->lang->line('type'), 'trim|required');

            $this->form_validation->set_rules('user_id', $this->lang->line('user'), 'trim|required');
            $this->form_validation->set_rules('password', $this->lang->line('password'), 'trim|required|min_length[6]|max_length[12]');
            $this->form_validation->set_rules('conf_password', $this->lang->line('password') . ' ' . $this->lang->line('confirm'), 'trim|required|matches[password]');

            if ($this->form_validation->run() === TRUE) {
                $data['password'] = md5($this->input->post('password'));
                $data['temp_password'] = base64_encode($this->input->post('password'));
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $this->setting->update('users', $data, array('id' => $this->input->post('user_id')));
                success($this->lang->line('update_success'));

                $user = $this->setting->get_single('employees', array('user_id' => $this->input->post('user_id')));
                create_log('Has been updated password for user : ' . $user->name);
                redirect('setting/password');
            }
        }
        $this->data['roles'] = $this->setting->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['role_id'] = $this->input->post('role_id');
        $this->data['user_id'] = $this->input->post('user_id');

        $this->layout->title($this->lang->line('reset_user_password') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('password/index', $this->data);
    }
}
