<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="align-items-center">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/mis/ipd'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('paid'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('unpaid'); ?></option>
                                <option value="3" <?php echo isset($type) && $type == 3 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no_reference'); ?></option>
                                <option value="4" <?php echo isset($type) && $type == 4 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('reference'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if ($_GET) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-money font-30 mr-10"></i>
                                <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a target="_blank" href="<?php echo site_url('report/mis/ipd_pdf/?type=' . $type . '&date=' . $date . '&reference_id=' . $reference_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm table-bordered mb-3" style="width:30%; float:right;">
                            <thead>
                                <tr>
                                    <th>Total Income</th>
                                    <th><?php echo ($total_ipd_invoices + $total_ipd_advance_payments + $total_ipd_due_invoices + $total_ipd_other_incomes); ?></th>
                                </tr>
                                <tr>
                                    <th>Total Expense</th>
                                    <th><?php echo ($total_surgeons + $total_anesthetists + $total_assistants + $total_ipd_other_expenses); ?></th>
                                </tr>
                                <tr>
                                    <th>Total Balance</th>
                                    <th><?php echo (($total_ipd_invoices + $total_ipd_advance_payments + $total_ipd_due_invoices + $total_ipd_other_incomes) - ($total_surgeons + $total_anesthetists + $total_assistants + $total_ipd_other_expenses)); ?></th>
                                </tr>
                            </thead>
                        </table>

                        <!-- IPD Income -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="8" class="bg-light text-center">IPD Income</th>
                                </tr>
                                <tr>
                                    <th>Patient ID</th>
                                    <th>Patient Name</th>
                                    <th>Doctor</th>
                                    <th>Reference</th>
                                    <th>Total</th>
                                    <th>Discount</th>
                                    <th>Paid</th>
                                    <th>Due</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_bill = 0;
                                $total_discount = 0;
                                $total_amount = 0;
                                $total_due_amount = 0;
                                foreach ($ipd_invoices as $obj) {
                                    $total_count += 1;
                                    $total_bill += $obj->total_bill;
                                    $total_discount += $obj->discount;
                                    $total_amount += $obj->amount;
                                    $total_due_amount += $obj->due_amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient_name; ?></td>
                                        <td><?php echo $obj->doctor; ?></td>
                                        <td><?php echo $obj->reference; ?></td>
                                        <td><?php echo $obj->total_bill; ?></td>
                                        <td><?php echo $obj->discount; ?></td>
                                        <td><?php echo $obj->amount; ?></td>
                                        <td><?php echo $obj->due_amount; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="4">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th><?php echo $total_bill; ?></th>
                                    <th><?php echo $total_discount; ?></th>
                                    <th><?php echo $total_amount; ?></th>
                                    <th><?php echo $total_due_amount; ?></th>
                                </tr>
                            </tfoot>
                        </table>

                        <!-- IPD Advance investigations -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="5" class="bg-light text-center">IPD Advance Collection</th>
                                </tr>
                                <tr>
                                    <th>Patient ID</th>
                                    <th>Patient Name</th>
                                    <th>Date</th>
                                    <th>Created By</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_amount = 0;
                                foreach ($ipd_advance_payments as $obj) {
                                    $total_count += 1;
                                    $total_amount += $obj->amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient_name; ?></td>
                                        <td><?php echo date('d/m/Y h:ia', strtotime($obj->payment_date)); ?></td>
                                        <td><?php echo $obj->creator; ?></td>
                                        <td><?php echo $obj->amount; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="4">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th><?php echo $total_amount; ?></th>
                                </tr>
                            </tfoot>
                        </table>

                        <!-- due investigations -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="5" class="bg-light text-center">Due Collection</th>
                                </tr>
                                <tr>
                                    <th>Patient ID</th>
                                    <th>Patient Name</th>
                                    <th>Date</th>
                                    <th>Created By</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_amount = 0;
                                foreach ($ipd_due_invoices as $obj) {
                                    $total_count += 1;
                                    $total_amount += $obj->amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient_name; ?></td>
                                        <td><?php echo date('d/m/Y h:ia', strtotime($obj->payment_date)); ?></td>
                                        <td><?php echo $obj->creator; ?></td>
                                        <td><?php echo $obj->amount; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="4">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th><?php echo $total_amount; ?></th>
                                </tr>
                            </tfoot>
                        </table>

                        <!-- IPD Other Income -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="5" class="bg-light text-center">IPD Income</th>
                                </tr>
                                <tr>
                                    <th>Income Head</th>
                                    <th>Name</th>
                                    <th>Payment Method</th>
                                    <th>Amount</th>
                                    <th>Created By</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_amount = 0;
                                foreach ($ipd_other_incomes as $obj) {
                                    $total_count += 1;
                                    $total_amount += $obj->amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->income_head; ?></td>
                                        <td><?php echo $obj->name; ?></td>
                                        <td><?php echo $obj->payment_method; ?></td>
                                        <td><?php echo $obj->amount; ?></td>
                                        <td><?php echo $obj->creator; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="3">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th colspan="2"><?php echo $total_amount; ?></th>
                                </tr>
                            </tfoot>
                        </table>



                        <!-- Surgeon -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="5" class="bg-light text-center">Surgeon Payment</th>
                                </tr>
                                <tr>
                                    <th>Patient ID</th>
                                    <th>Patient Name</th>
                                    <th>Doctor</th>
                                    <th>Charge</th>
                                    <th>Payment</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_doctor_charge = 0;
                                $total_payment = 0;
                                foreach ($surgeons as $obj) {
                                    $total_count += 1;
                                    $total_doctor_charge += $obj->commission_amount;
                                    $total_payment += $obj->payable_amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient_name; ?></td>
                                        <td><?php echo $obj->doctor; ?></td>
                                        <td><?php echo $obj->commission_amount; ?></td>
                                        <td><?php echo $obj->payable_amount; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="3">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th><?php echo $total_doctor_charge; ?></th>
                                    <th><?php echo $total_payment; ?></th>
                                </tr>
                            </tfoot>
                        </table>


                        <!-- anesthetists -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="5" class="bg-light text-center">Anesthesia Payment</th>
                                </tr>
                                <tr>
                                    <th>Patient ID</th>
                                    <th>Patient Name</th>
                                    <th>Doctor</th>
                                    <th>Charge</th>
                                    <th>Payment</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_doctor_charge = 0;
                                $total_payment = 0;
                                foreach ($anesthetists as $obj) {
                                    $total_count += 1;
                                    $total_doctor_charge += $obj->commission_amount;
                                    $total_payment += $obj->payable_amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient_name; ?></td>
                                        <td><?php echo $obj->doctor; ?></td>
                                        <td><?php echo $obj->commission_amount; ?></td>
                                        <td><?php echo $obj->payable_amount; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="3">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th><?php echo $total_doctor_charge; ?></th>
                                    <th><?php echo $total_payment; ?></th>
                                </tr>
                            </tfoot>
                        </table>

                        <!-- assistants -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="5" class="bg-light text-center">Assistant Payment</th>
                                </tr>
                                <tr>
                                    <th>Patient ID</th>
                                    <th>Patient Name</th>
                                    <th>Doctor</th>
                                    <th>Charge</th>
                                    <th>Payment</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_doctor_charge = 0;
                                $total_payment = 0;
                                foreach ($assistants as $obj) {
                                    $total_count += 1;
                                    $total_doctor_charge += $obj->commission_amount;
                                    $total_payment += $obj->payable_amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient_name; ?></td>
                                        <td><?php echo $obj->doctor; ?></td>
                                        <td><?php echo $obj->commission_amount; ?></td>
                                        <td><?php echo $obj->payable_amount; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="3">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th><?php echo $total_doctor_charge; ?></th>
                                    <th><?php echo $total_payment; ?></th>
                                </tr>
                            </tfoot>
                        </table>

                        <!-- IPD Other Expense -->
                        <table class="table table-sm table-bordered mt-3 mb-0">
                            <thead>
                                <tr>
                                    <th colspan="5" class="bg-light text-center">IPD Expenses</th>
                                </tr>
                                <tr>
                                    <th>Expense Head</th>
                                    <th>Name</th>
                                    <th>Payment Method</th>
                                    <th>Amount</th>
                                    <th>Created By</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_count = 0;
                                $total_amount = 0;
                                foreach ($ipd_other_expenses as $obj) {
                                    $total_count += 1;
                                    $total_amount += $obj->amount;
                                ?>
                                    <tr>
                                        <td><?php echo $obj->income_head; ?></td>
                                        <td><?php echo $obj->name; ?></td>
                                        <td><?php echo $obj->payment_method; ?></td>
                                        <td><?php echo $obj->amount; ?></td>
                                        <td><?php echo $obj->creator; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th align="right" colspan="3">
                                        <?php echo $this->lang->line('total'); ?> -
                                        <?php echo $total_count; ?>
                                    </th>
                                    <th colspan="2"><?php echo $total_amount; ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });

    $('input[id="range"]').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    });

    $('input[id="range"]').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
</script>