<!DOCTYPE html>
<html>

<head>
    <title>Due</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">DUE REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($doctor_id) && !empty($doctor_id)) { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $doctor->name; ?>, <?php echo $doctor->specialist; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width: 7%;">SL No</th>
                            <th style="width: 12%;">Invoice No</th>
                            <th style="width: 12%;">Date</th>
                            <th style="width: 15%;">Patient Name</th>
                            <th style="width: 10%;">Patient ID</th>
                            <th style="width: 12%;">Doctor</th>
                            <th style="width: 12%;">Reference</th>
                            <th style="width: 10%;">Due</th>
                            <th style="width: 10%;">Remark</th>
                            <th style="width: 10%;">Created By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_due_amount = 0;
                        if (isset($dues) && !empty($dues)) { ?>
                            <?php foreach ($dues as $obj) {
                                $total_due_amount += $obj->due_amount;
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo date('d/m/Y h:i A', strtotime($obj->bill_date)); ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->doctor; ?></td>
                                    <td><?php echo $obj->reference; ?></td>
                                    <td><?php echo $obj->due_amount; ?></td>
                                    <td><?php echo $obj->remark; ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                <?php } ?>
                                <tr>
                                    <td colspan="8" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Amount:</th>
                                    <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_due_amount, 2); ?></th>
                                </tr>
                            <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php if (isset($created_by) && !empty($created_by)) {
                                        echo $createdby->name;
                                    } else {
                                        echo $this->session->userdata('name');
                                    } ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>