<!DOCTYPE html>
<html>

<head>
    <title>Daily Income</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">DAILY INCOME REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($doctor_id) && !empty($doctor_id)) { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $doctor->name; ?>, <?php echo $doctor->specialist; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                            <th>
                                <?php echo $this->lang->line('invoice_no'); ?>
                                /
                                <?php echo $this->lang->line('date'); ?>
                            </th>
                            <th>
                                <?php echo $this->lang->line('patient_id'); ?>
                                /
                                <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?>
                            </th>
                            <th><?php echo $this->lang->line('doctor'); ?></th>
                            <th><?php echo $this->lang->line('reference'); ?></th>
                            <th><?php echo $this->lang->line('total'); ?></th>
                            <th><?php echo $this->lang->line('discount'); ?></th>
                            <th><?php echo $this->lang->line('net_payable'); ?></th>
                            <th><?php echo $this->lang->line('advanced'); ?></th>
                            <th><?php echo $this->lang->line('due'); ?></th>
                            <th><?php echo $this->lang->line('reference'); ?> <?php echo $this->lang->line('payment'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_bill_amount = 0;
                        $total_discount = 0;
                        $total_net_payable = 0;
                        $total_advanced = 0;
                        $total_due_amount = 0;
                        $total_reference_pay = 0;
                        if (isset($collections) && !empty($collections)) { ?>
                            <?php foreach ($collections as $obj) {
                                $total_bill_amount += $obj->total_bill;
                                $total_discount += $obj->discount;
                                $total_net_payable += $obj->net_payable;
                                $total_advanced += $obj->advanced;
                                $total_reference_pay += $obj->reference_pay;
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td>
                                        <?php echo $obj->custom_invoice_id; ?>
                                        <br>
                                        <?php echo date('d/m/Y h:i A', strtotime($obj->bill_date)); ?>
                                    </td>
                                    <td>
                                        <?php echo $obj->patient_unique_id; ?>
                                        <br>
                                        <?php echo $obj->patient; ?>
                                    </td>
                                    <td>
                                        <?php if ($obj->self) {
                                            echo 'Self';
                                        } elseif ($obj->ref_dr_id > 0) {
                                            echo $obj->doctor;
                                        } else {
                                            echo $obj->ref_dr_name;
                                        } ?>
                                    </td>
                                    <td><?php echo $obj->reference; ?></td>
                                    <td><?php echo $obj->total_bill; ?></td>
                                    <td><?php echo $obj->discount; ?></td>
                                    <td><?php echo $obj->net_payable; ?></td>
                                    <td><?php echo $obj->advanced; ?></td>
                                    <td><?php echo $obj->due_amount; ?></td>
                                    <td><?php echo $obj->reference_pay; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <table class="table table_content" style="text-align: center; width: 50%; margin: 30px auto 0 auto;">
                <tbody class="border-bottom border-1">
                    <tr>
                        <td class="text-right font-weight-600">Total Amount</td>
                        <td class="text-left font-weight-600"><?php echo number_format($total_bill_amount, 2); ?></td>
                    </tr>
                    <tr>
                        <td class="text-right font-weight-600">Total Discount</td>
                        <td class="text-left font-weight-600"><?php echo number_format($total_discount, 2); ?></td>
                    </tr>
                    <tr>
                        <td class="text-right font-weight-600">Total Net Payable</td>
                        <td class="text-left font-weight-600"><?php echo number_format($total_net_payable, 2); ?></td>
                    </tr>
                    <tr>
                        <td class="text-right font-weight-600">Total Advanced</td>
                        <td class="text-left font-weight-600"><?php echo number_format($total_advanced, 2); ?></td>
                    </tr>
                    <tr>
                        <td class="text-right font-weight-600">Total Due</td>
                        <td class="text-left font-weight-600"><?php echo number_format($total_due_amount, 2); ?></td>
                    </tr>
                    <tr>
                        <td class="text-right font-weight-600">Total Reference Payment</td>
                        <td class="text-left font-weight-600"><?php echo number_format($total_reference_pay, 2); ?></td>
                    </tr>
                    <tr>
                        <td class="text-right font-weight-600">Total Balance</td>
                        <td class="text-left font-weight-600">
                            <?php echo number_format(($total_advanced - $total_reference_pay), 2); ?>
                        </td>
                    </tr>
                </tbody>
            </table>
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php if (isset($created_by) && !empty($created_by)) {
                                        echo $createdby->name;
                                    } else {
                                        echo $this->session->userdata('name');
                                    } ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>