<!DOCTYPE html>
<html>

<head>
    <title>Daily</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">DAILY ATTENDANCE REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if (isset($user_id) && !empty($user_id)) { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $employee->name; ?>, <?php echo $employee->phone; ?>
                                    </span>
                                <?php } elseif (isset($department_id) && !empty($department_id)) { ?>
                                    <b>Department:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $department->name; ?>
                                    </span>
                                <?php } elseif (isset($shift_id) && !empty($shift_id)) { ?>
                                    <b>Shift:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $shift->name; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th width="7%"><?php echo $this->lang->line('sl_no'); ?></th>
                            <th width="15%"><?php echo $this->lang->line('name'); ?></th>
                            <th width="10%"><?php echo $this->lang->line('designation'); ?></th>
                            <th width="9%"><?php echo $this->lang->line('shift'); ?></th>
                            <th width="10%"><?php echo $this->lang->line('date'); ?></th>
                            <th width="8%"><?php echo $this->lang->line('clock_in'); ?></th>
                            <th width="8%"><?php echo $this->lang->line('clock_out'); ?></th>
                            <th width="8%"><?php echo $this->lang->line('late'); ?></th>
                            <th width="9%"><?php echo $this->lang->line('early_leaving'); ?></th>
                            <th width="7%"><?php echo $this->lang->line('total'); ?></th>
                            <th width="9%"><?php echo $this->lang->line('status'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        if (isset($attendances) && !empty($attendances)) { ?>
                            <?php foreach ($attendances as $obj) { ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->name; ?></td>
                                    <td><?php echo $obj->designation; ?></td>
                                    <td><?php echo $obj->shift; ?></td>
                                    <td><?php echo date('M d, Y', strtotime($obj->date)); ?></td>
                                    <td><?php echo $obj->clock_in ? date('h:ia', strtotime($obj->clock_in)) : ''; ?></td>
                                    <td><?php echo $obj->clock_out ? date('h:ia', strtotime($obj->clock_out)) : ''; ?></td>
                                    <td>
                                        <?php
                                        if ($obj->late) {
                                            echo date('H', strtotime($obj->late)) > 0 ? date('H', strtotime($obj->late)) . 'H ' : '';
                                            echo date('i', strtotime($obj->late)) > 0 ?  date('i', strtotime($obj->late)) . 'M' : '';
                                        } ?>
                                    </td>
                                    <td>
                                        <?php
                                        if ($obj->early_leaving) {
                                            echo date('H', strtotime($obj->early_leaving)) > 0 ? date('H', strtotime($obj->early_leaving)) . 'H ' : '';
                                            echo date('i', strtotime($obj->early_leaving)) > 0 ?   date('i', strtotime($obj->early_leaving)) . 'M' : '';
                                        } ?>
                                    </td>
                                    <td>
                                        <?php
                                        if ($obj->total) {
                                            echo date('H', strtotime($obj->total)) > 0 ? date('H', strtotime($obj->total)) . 'H ' : '';
                                            echo date('i', strtotime($obj->total)) > 0 ? date('i', strtotime($obj->total)) . 'M' : '';
                                        } ?>
                                    </td>
                                    <td><?php echo get_attendance_badge($obj->attendance_status); ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>