<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Employee_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_employee_list($keyword, $role_id, $commission_type, $department_id, $designation_id, $gender, $religion, $blood_group) {
        $this->db->select('E.*, U.device_id, R.name as role, C.first_fee, C.second_fee, C.hospital_commission, DP.name as department, D.name as designation');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->join('doctor_charges AS C', 'C.doctor_id = E.user_id', 'left');
        $this->db->join('departments AS DP', 'DP.id = E.department_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($keyword) {
            $this->db->like('U.device_id', $keyword);
            $this->db->or_like('E.name', $keyword, 'both');
        }
        if ($role_id) {
            $this->db->where('U.role_id', $role_id);
        }
        if ($commission_type) {
            $this->db->where('E.commission_type', $commission_type);
        }
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($gender) {
            $this->db->where('E.gender', $gender);
        }
        if ($religion) {
            $this->db->where('E.religion', $religion);
        }
        if ($blood_group) {
            $this->db->where('E.blood_group', $blood_group);
        }
        $this->db->where('E.status', '1');
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }
}
