<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Diagnostic_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_diagnostic_list($keyword, $special_discount, $department_id, $group_id) {
        $this->db->select('D.*, DD.name as department, DG.name as group');
        $this->db->from('diagnostic_tests AS D');
        $this->db->join('diagnostic_departments AS DD', 'DD.id = D.department_id', 'left');
        $this->db->join('diagnostic_groups AS DG', 'DG.id = D.group_id', 'left');
        if ($keyword) {
            $this->db->like('D.code', $keyword);
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('DD.name', $keyword, 'both');
            $this->db->or_like('DG.name', $keyword, 'both');
            $this->db->or_like('D.room_no', $keyword, 'both');
            $this->db->or_like('D.specimen', $keyword, 'both');
            $this->db->or_like('D.rate', $keyword, 'both');
        }
        if ($special_discount && $special_discount == 'yes') {
            $this->db->where('D.special_discount >', 0);
        }
        if ($department_id) {
            $this->db->where('D.department_id', $department_id);
        }
        if ($group_id) {
            $this->db->where('D.group_id', $group_id);
        }
        $this->db->order_by('D.id', 'ASC');
        return $this->db->get()->result();
    }
}
