<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Schedule.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Schedule
 * @description     : Manage doctor schedule report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Schedule extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Schedule_Model', 'schedule', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Doctor Schedule Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $type = $this->input->get('type');
            $slot = $this->input->get('slot');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $status = $this->input->get('status');
            $doctor_id = $this->input->get('doctor_id');
            if ($doctor_id) {
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[0]));
            }
            $created_by = $this->input->get('created_by');

            $this->data['schedules'] = $this->schedule->get_schedule_list($slot, $form_date, $to_date, $status, $doctor_id, $created_by);
            $this->data['type'] = $type;
            $this->data['slot'] = $slot;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['status'] = $status;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['doctors'] = $this->schedule->get_doctor_list();
        $this->data['employees'] = $this->schedule->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('doctor') . ' ' . $this->lang->line('schedule') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/schedule/index', $this->data);
    }

    public function pdf() {
        if ($_GET && $this->input->get('date')) {
            $type = $this->input->get('type');
            $slot = $this->input->get('slot');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $status = $this->input->get('status');
            $doctor_id = $this->input->get('doctor_id');
            if ($doctor_id) {
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[0]));
            }
            $created_by = $this->input->get('created_by');

            $this->data['schedules'] = $this->schedule->get_schedule_list($slot, $form_date, $to_date, $status, $doctor_id, $created_by);
            $this->data['doctor'] = $this->schedule->get_single('employees', array('user_id' => $doctor_id));
            $this->data['type'] = $type;
            $this->data['slot'] = $slot;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['status'] = $status;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L',
                'default_font' => 'bangla'
            ]);
            $html =  $this->load->view('report/schedule/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('schedule_' . rand() . '.pdf', 'I');
        }
    }
}
