<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm mb-0">
            <thead>
                <tr>
                    <th><?php echo $this->lang->line('sl_no'); ?></th>
                    <th><?php echo $this->lang->line('invoice_no'); ?></th>
                    <th><?php echo $this->lang->line('date'); ?></th>
                    <th><?php echo $this->lang->line('customer'); ?></th>
                    <th><?php echo $this->lang->line('patient_id'); ?></th>
                    <th><?php echo $this->lang->line('medicine'); ?></th>
                    <th><?php echo $this->lang->line('batch_no'); ?></th>
                    <th><?php echo $this->lang->line('expire'); ?></th>
                    <th><?php echo $this->lang->line('quantity'); ?></th>
                    <th><?php echo $this->lang->line('sale'); ?> <?php echo $this->lang->line('price'); ?></th>
                    <th><?php echo $this->lang->line('total'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if (isset($sales) && !empty($sales)) { ?>
                    <?php foreach ($sales as $obj) { ?>
                        <tr>
                            <td><?php echo $sl_count; ?></td>
                            <td><?php echo $obj->custom_invoice_id; ?></td>
                            <td><?php echo date('d M, Y h:ia', strtotime($obj->bill_date)); ?></td>
                            <td>
                                <?php
                                if ($obj->walking == 1) {
                                    echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                } elseif ($obj->customer_id > 0) {
                                    echo $obj->customer;
                                } else {
                                    echo $obj->customer_name;
                                }
                                ?>
                            </td>
                            <td><?php echo $obj->patient_unique_id; ?></td>
                            <td>
                                <a target="_blank" href="<?php echo site_url('pharmacy/sale/invoice/' . $obj->invoice_id); ?>"><?php echo $obj->medicine_name; ?></a>
                            </td>
                            <td></td>
                            <td></td>
                            <td><?php echo $obj->quantity; ?></td>
                            <td><?php echo $obj->rate; ?></td>
                            <td><?php echo $obj->total_rate; ?></td>
                        </tr>
                        <?php $sl_count++; ?>
                    <?php } ?>
                <?php } else { ?>
                    <tr>
                        <td colspan="11"><?php echo $this->lang->line('no_data_found'); ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Card Footer -->
<?php if ($this->pagination->create_links()) { ?>
    <div class="card-footer justify-content-end">
        <?php echo $this->pagination->create_links(); ?>
    </div>
<?php } ?>