<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Refund_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, PHARMACIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_customer_refund_invoice_list($limit, $offset, $keyword, $type, $form_date, $to_date, $created_by, $count) {
        $this->db->select('R.*, I.walking, I.customer_name, I.customer_id, P.patient_unique_id, P.name as customer, E.name as employee');
        $this->db->from('medicine_refunds AS R');
        $this->db->join('medicine_invoices AS I', 'I.id = R.sale_invoice_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = I.customer_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = R.created_by', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id ', $keyword);
            $this->db->or_like('R.custom_invoice_id ', $keyword);
            $this->db->or_like('I.customer_name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->where('R.paid_status', 'paid');
        }
        if ($type == 2) {
            $this->db->where('R.paid_status', 'unpaid');
        }
        if ($type == 3) {
            $this->db->where('I.walking', '1');
        }
        if ($type == 4) {
            $this->db->where('I.customer_id >', '0');
        }
        if ($type == 5) {
            $this->db->where('R.payment_status', 'complete');
        }
        if ($type == 6) {
            $this->db->where('R.payment_status', 'rejected');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(R.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('R.created_by', $created_by);
        }
        $this->db->order_by('R.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_invoice_detail_list($invoice_id) {
        $this->db->select('MD.*, M.medicine_name');
        $this->db->from('medicine_invoice_details AS MD');
        $this->db->join('medicines AS M', 'M.id = MD.medicine_id', 'left');
        $this->db->where('MD.invoice_id ', $invoice_id);
        $this->db->order_by('MD.id ', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_customer($invoice_id) {
        $this->db->select('R.*, P.name as customer, P.patient_unique_id, P.gender, P.address, P.phone, P.email, P.dob, I.customer_id, I.walking, I.customer_name');
        $this->db->from('medicine_refunds AS R');
        $this->db->join('medicine_invoices AS I', 'I.id = R.sale_invoice_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = I.customer_id', 'left');
        $this->db->where('R.id ', $invoice_id);
        return $this->db->get()->row();
    }

    public function get_refund_medicine_invoice_list($invoice_id) {
        $this->db->select('RD.*, M.medicine_name');
        $this->db->from('medicine_refund_details AS RD');
        $this->db->join('medicine_refunds AS R', 'R.id = RD.invoice_id ', 'left');
        $this->db->join('medicines AS M', 'M.id = RD.medicine_id', 'left');
        $this->db->where('R.id ', $invoice_id);
        $this->db->where('R.payment_status ', 'complete');
        $this->db->order_by('RD.id ', 'ASC');
        return $this->db->get()->result();
    }
}
