<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Purchase_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, PHARMACIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_purchase_invoice_list($limit, $offset, $keyword, $payment_type, $form_date, $to_date, $manufacturer_id, $created_by, $count) {
        $this->db->select('MP.*, M.name as manufacturer');
        $this->db->from('medicine_purchases AS MP');
        $this->db->join('manufacturers AS M', 'M.id = MP.manufacturer_id', 'left');
        if ($keyword) {
            $this->db->like('MP.custom_invoice_id', $keyword);
            $this->db->or_like('M.name', $keyword, 'both');
        }
        if ($payment_type) {
            $this->db->where('MP.payment_type', $payment_type);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(MP.purchase_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($manufacturer_id) {
            $this->db->where('MP.manufacturer_id', $manufacturer_id);
        }
        if ($created_by) {
            $this->db->where('MP.created_by', $created_by);
        }
        $this->db->order_by('MP.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_medicine_search_list($manufacturer_id, $search) {
        $this->db->select('M.*');
        $this->db->from('medicines AS M');
        $this->db->where('M.manufacturer_id', $manufacturer_id);
        if ($search) {
            $this->db->like('M.medicine_name', $search, 'both');
            $this->db->or_like('M.code', $search, 'both');
        }
        $this->db->order_by('M.medicine_name', 'ASC');
        $this->db->limit(20);
        return $this->db->get()->result();
    }


    public function get_medicine_purchase_list($purchase_id) {
        $this->db->select('PD.*, M.medicine_name, C.name as category');
        $this->db->from('medicine_purchase_details AS PD');
        $this->db->join('medicines AS M', 'M.id = PD.medicine_id', 'left');
        $this->db->join('medicine_categories AS C', 'C.id = M.category_id', 'left');
        $this->db->where('PD.purchase_id', $purchase_id);
        $this->db->order_by('PD.id ', 'ASC');
        return $this->db->get()->result();
    }


    public function get_medicine_purchase_payment_list($purchase_id) {
        $this->db->select('P.*, E.name as employee');
        $this->db->from('medicine_purchase_payments AS P');
        $this->db->join('employees AS E', 'E.user_id = P.created_by', 'left');
        $this->db->where('P.invoice_id ', $purchase_id);
        $this->db->order_by('P.id ', 'DESC');
        return $this->db->get()->result();
    }
}
