<div class="col-lg-3">
    <div class="card card-profile-feed">
        <div class="card-header card-header-action">
            <div class="media align-items-center">
                <div class="media-img-wrap d-flex mr-10">
                    <div class="avatar avatar-sm">
                        <?php if ($profile->photo) { ?>
                            <img src="<?php echo UPLOAD_PATH; ?>patient-photo/<?php echo $profile->photo; ?>" alt="user" class="avatar-img rounded-circle">
                        <?php } elseif ($profile->gender == 'male') { ?>
                            <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                        <?php } else { ?>
                            <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                        <?php }  ?>
                    </div>
                </div>
                <div class="media-body">
                    <div class="text-capitalize font-weight-500 text-dark"><?php echo $profile->name; ?></div>
                    <div class="font-13"><?php echo $profile->bn_name ? $profile->bn_name : ''; ?></div>
                </div>
            </div>
        </div>
        <div class="row text-center">
            <div class="col-6 border-right px-0">
                <div class="pa-15">
                    <span class="d-block display-6 text-dark mb-5">
                        <?php echo $this->opd->count_all('opd_patients', array('patient_id' => $profile->user_id, 'payment_status' => 'complete')); ?>
                    </span>
                    <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('visit'); ?></span>
                </div>
            </div>
            <div class="col-6 pr-0">
                <div class="pa-15">
                    <span class="d-block display-6 text-dark mb-5">
                        <?php
                        $invoices = $this->opd->count_patient_all_invoices($profile->user_id);
                        $Investigations = 0;
                        foreach ($invoices as $obj) {
                            $Investigations += $this->opd->count_patient_all_investigations($obj->id);
                        }
                        echo $Investigations;
                        ?>
                    </span>
                    <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('investigations'); ?></span>
                </div>
            </div>
        </div>
        <ul class="list-group list-group-flush">
            <li class="list-group-item">
                <i class="fa fa-id-badge font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('patient_id'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $profile->patient_unique_id; ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-phone font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('phone'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $profile->phone; ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-envelope font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('email'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $profile->email; ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-venus font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('gender'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $this->lang->line($profile->gender); ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-delicious font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('religion'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $this->lang->line($profile->religion); ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-fire font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('blood_group'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $this->lang->line($profile->blood_group); ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-mars-double font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('marital_status'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $this->lang->line($profile->marital_status); ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-user font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('guardian_name'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $profile->guardian_name; ?></span>
            </li>
            <li class="list-group-item">
                <i class="fa fa-home font-18 text-light-20 mr-10"></i>
                <span><?php echo $this->lang->line('address'); ?>:</span>
                <span class="ml-5 text-dark"><?php echo $profile->address; ?></span>
            </li>
        </ul>
    </div>
    <div class="card card-profile-feed">
        <div class="card-header card-header-action">
            <h6>
                <span><?php echo $this->lang->line('latest'); ?> <?php echo $this->lang->line('patient'); ?>
                    <span class="badge badge-soft-primary ml-5">
                        <?php echo number_format($this->opd->count_all('patients', array('status' => 1)), 0, ',', ','); ?>
                    </span>
                </span>
            </h6>
            <a href="<?php echo site_url('patient'); ?>" class="font-14 ml-auto"><?php echo $this->lang->line('view_all'); ?></a>
        </div>
        <div class="card-body pb-5">
            <div class="hk-row text-center">
                <?php foreach ($latest_patients as $obj) { ?>
                    <div class="col-3 mb-15">
                        <div class="w-100">
                            <?php if ($obj->photo) { ?>
                                <img style="width: 100%; height: 70px;" src="<?php echo UPLOAD_PATH; ?>patient-photo/<?php echo $obj->photo; ?>" alt="user" class="img-fluid rounded">
                            <?php } elseif ($obj->gender == 'male') { ?>
                                <img style="width: 100%; height: 70px;" src="<?php echo IMG_URL; ?>male.png" alt="male" class="img-fluid rounded">
                            <?php } else { ?>
                                <img style="width: 100%; height: 70px;" src="<?php echo IMG_URL; ?>female.png" alt="female" class="img-fluid rounded">
                            <?php }  ?>
                        </div>
                        <span class="d-block font-14 text-truncate">
                            <a href="<?php echo site_url('opd/profile/' . $obj->user_id); ?>">
                                <?php echo $obj->name; ?>
                            </a>
                        </span>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>