<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Sms_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_sms_list($limit, $offset, $search, $count) {
        $this->db->select('TM.*, R.name as role, E.name as created_by');
        $this->db->from('text_messages AS TM');
        $this->db->join('roles AS R', 'R.id = TM.role_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = TM.created_by', 'left');
        if ($search) {
            $this->db->like('TM.body', $search, 'both');
            $this->db->or_like('R.name', $search, 'both');
            $this->db->or_like('E.name', $search, 'both');
        }
        $this->db->where('TM.sms_type', 'general');
        $this->db->order_by('TM.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_user_list($role_id, $receiver_id) {

        if ($role_id == SUPER_ADMIN) {
            $this->db->select('E.*');
            $this->db->from('employees AS E');
            $this->db->join('users AS U', 'U.id = E.user_id', 'left');
            $this->db->where('U.role_id', $role_id);
            $this->db->where('U.status', 1);
            $this->db->where('E.status', 1);
            if ($receiver_id > 0) {
                $this->db->where('E.user_id', $receiver_id);
            }
            return $this->db->get()->result();
        } elseif ($role_id == PATIENT) {
            $this->db->select('P.*');
            $this->db->from('patients AS P');
            $this->db->join('users AS U', 'U.id = P.user_id', 'left');
            $this->db->where('U.role_id', $role_id);
            $this->db->where('U.status', 1);
            $this->db->where('P.status', 1);
            if ($receiver_id > 0) {
                $this->db->where('E.user_id', $receiver_id);
            }
            return $this->db->get()->result();
        } else {
            $this->db->select('E.*');
            $this->db->from('employees AS E');
            $this->db->join('users AS U', 'U.id = E.user_id', 'left');
            $this->db->where('U.role_id', $role_id);
            $this->db->where('U.status', 1);
            $this->db->where('E.status', 1);
            if ($receiver_id > 0) {
                $this->db->where('E.user_id', $receiver_id);
            }
            return $this->db->get()->result();
        }
    }

    public function get_single_sms($id) {
        $this->db->select('TM.*, R.name as role, E.name as created_by');
        $this->db->from('text_messages AS TM');
        $this->db->join('roles AS R', 'R.id = TM.role_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = TM.created_by', 'left');
        $this->db->where('TM.id', $id);
        return $this->db->get()->row();
    }
}
