<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Charge_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_patient_charge_list($limit, $offset, $ipd_id, $search, $count) {
        $this->db->select('IC.*, C.name as charge_name, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, PA.paid_status');
        $this->db->from('ipd_charges AS IC');
        $this->db->join('patients AS P', 'P.user_id = IC.patient_id', 'left');
        $this->db->join('charges AS C', 'C.id = IC.charge_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IC.ipd_id', 'left');
        $this->db->join('payments AS PA', 'PA.invoice_id = IC.id AND PA.invoice_type = IC.type', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.bn_name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.religion', $search);
            $this->db->or_like('P.blood_group', $search);
            $this->db->or_like('P.marital_status', $search);
            $this->db->or_like('P.address', $search);
            $this->db->or_like('C.name', $search);
            $this->db->or_like('IC.instruction', $search);
            $this->db->or_like('IC.charge_status', $search);
            $this->db->group_end();
        }
        $this->db->where('IC.ipd_id', $ipd_id);
        $this->db->order_by('IC.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_charge($id) {
        $this->db->select('IC.*, CH.name as charge_name, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, C.name as created_by, M.name as modified_by');
        $this->db->from('ipd_charges AS IC');
        $this->db->join('patients AS P', 'P.user_id = IC.patient_id', 'left');
        $this->db->join('charges AS CH', 'CH.id = IC.charge_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IC.ipd_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IC.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = IC.modified_by', 'left');
        $this->db->where('IC.id', $id);
        return $this->db->get()->row();
    }
}
