<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Anesthesia_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list() {
        $this->db->select('A.*');
        $this->db->from('anesthetists AS A');
        $this->db->where('A.status', 1);
        $this->db->order_by('A.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient_anesthesia_list($limit, $offset, $ipd_id, $search, $count) {
        $this->db->select('IA.*, A.name as doctor, A.specialist, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, PA.paid_status');
        $this->db->from('ipd_anesthesias AS IA');
        $this->db->join('patients AS P', 'P.user_id = IA.patient_id', 'left');
        $this->db->join('anesthetists AS A', 'A.user_id = IA.doctor_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IA.ipd_id', 'left');
        $this->db->join('payments AS PA', 'PA.invoice_id = IA.id AND PA.invoice_type = IA.type', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.bn_name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.religion', $search);
            $this->db->or_like('P.blood_group', $search);
            $this->db->or_like('P.marital_status', $search);
            $this->db->or_like('P.address', $search);
            $this->db->or_like('A.name', $search);
            $this->db->or_like('IA.instruction', $search);
            $this->db->or_like('IA.anesthesia_status', $search);
            $this->db->group_end();
        }
        $this->db->where('IA.ipd_id', $ipd_id);
        $this->db->order_by('IA.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_anesthesia($id) {
        $this->db->select('IA.*, A.name as doctor, A.specialist, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, C.name as created_by, M.name as modified_by');
        $this->db->from('ipd_anesthesias AS IA');
        $this->db->join('patients AS P', 'P.user_id = IA.patient_id', 'left');
        $this->db->join('anesthetists AS A', 'A.user_id = IA.doctor_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IA.ipd_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IA.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = IA.modified_by', 'left');
        $this->db->where('IA.id', $id);
        return $this->db->get()->row();
    }
}
