<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('ipd'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hospital/ipd/left-side'); ?>
        <!-- col-xl-9 -->
        <div class="col-lg-9">
            <!-- Counter Start -->
            <div class="hk-row">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('charge'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->ipd->count_all('charges', array('status' => 1)); ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/ipd/charge'); ?>" class="btn btn-primary btn-sm">
                                        <i class="fa fa-link" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('amount'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->ipd->get_total_charge()->total_price ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/ipd/charge'); ?>" class="btn btn-success btn-sm">
                                        <i class="fa fa-money" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('package'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->ipd->count_all('ipd_packages', array('status' => 1)); ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/ipd/package'); ?>" class="btn btn-info btn-sm">
                                        <i class="fa fa-money" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('amount'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->ipd->get_total_package_price()->total_price ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/ipd/package'); ?>" class="btn btn-orange btn-sm">
                                        <i class="fa fa-money" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->