<!DOCTYPE html>
<html>

<head>
    <title>Print Visit Bill</title>

    <style>
        body {
            font-family: monospace;
            font-size: 14px;
        }

        .page {
            width: 60%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 60%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                /*page-break-after: always; */
            }
            .page1 {
                page-break-after: always;
            }
        }

        .patient_info {
            display: block;
            margin-top: 100px;
            min-height: 500px;
            position: relative;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
          border: 1px solid #000;
        }

        .patient_table tbody td {
            color: #000;
            padding: 3px 2px;
            vertical-align: middle;
            font-size: 14px;
        }
      	.patient_follow tbody td {
            color: #000;
            padding: 3px 2px;
            vertical-align: middle;
            font-size: 14px;
          	border: 1px solid #222;
        }

        .title {
            border: 1px solid #222;
            border-radius: 10px;
            font-size: 15px;
            text-align: center;
            width: 80%;
            font-weight: bold;
            text-transform: uppercase;
        }

        .flowup {
            width: 90%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .font-size {
            font-size: 13px;
        }

        /* Service Tabl */
        .service_table {
            width: 100%;
            margin-top: 10px;
          	border-collapse: collapse;
        }

        .service_table thead,
        tbody th,
        td {
            color: #000;
            padding: 3px 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
        }

        .border {
            border-top: 1px dashed #000;
            border-bottom: 0;
            border-right: 0;
            border-left: 0;
        }

        .paid {
            width: 25%;
            margin: 10px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 1px solid #000;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        p {
            text-align: center;
        }

        .powered_by {
            writing-mode: vertical-lr;
            -webkit-transform: rotate(180deg);
            -moz-transform: rotate(180deg);
            font-size: 8px;
            font-family: 'Times New Roman', Times, serif;
            position: absolute;
            left: -15px;
            top: 80px;
            color: #000;
        }

        .table .top-header thead,
        tbody th,
        td {
            border: 0;
        }
    </style>
</head>

<body>
    <div class="page page1">
        <div class="patient_info">
            <table class="table">
            <tr>
                <td rowspan="3" width="20%" style="margin-bottom:10px">
                    <?php if($this->global_setting->brand_logo){ ?>
                        <img width="80" valign="middle" align="center" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>">
                    <?php } else { ?>
                        <img width="80" valign="middle" align="center" src="<?php echo IMG_URL; ?>logo.png">
                    <?php } ?>
                </td>
                <td width="80%" align="center"><h1 style="margin: 0px; padding:0; font-size: 25px;"><?php echo $this->global_setting->brand_title; ?></h1></td>
            </tr>
            <tr>
                <td align="center"><p style="margin: 0px; padding: 0; font-size: 14px;"><?php echo $this->global_setting->address; ?></p></td>
            </tr>
            <tr>
                 <td align="center"><p style="margin: 0; font-size: 14px;">Phone: <?php echo $this->global_setting->phone; ?></p></td>
            </tr>
        </table>
          <table style="margin-top: 10px;" class="table">
          	<tr>
              <td style="width: 25%;">
                <img align="left" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>
              <td>
              	<div class="title">Patient Copy</div>
              </td>
              <td style="width: 25%;">
              	<img align="right" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>            
            </tr>
          </table>
            
            <!-- Patient Info Start-->
            <table class="table patient_follow">
                <tr>
                    <td width="31%"><b>Serial No:</b> <span class="font-size"><?php echo $patient->serial_no; ?></span></td>
                    <td rowspan="2" width="35%">
                        <div class="flowup">
                            <?php if ($patient->old_patient) {
                                echo 'SECOND FLOWUP';
                            } else {
                                echo 'FIRST FLOWUP';
                            } ?>
                        </div>
                    </td>
                    <td width="34%"><b>App No:</b> <span class="font-size"><?php echo $patient->appointment_no; ?></span></td>
                </tr>
                <tr>
                    <td><b>Patient ID:</b> <span class="font-size"><?php echo $patient->patient_unique_id; ?></span></td>
                    <td><span class="font-size"><?php echo date('d/m/Y', strtotime($patient->appointment_date)); ?></span></td>
                </tr>
              </table>
                
              
              <table style="border-top: none;" class="table patient_table">
                <tr>
                    <td style="width: 60%"><b>Name:</b> <span class="font-size" style="text-transform: uppercase;"><?php echo $patient->name; ?></span></td>
                    <td><b>Bill No:</b> <span class="font-size"><?php echo $patient->custom_invoice_id; ?></span></td>
                </tr>
                <tr>
                    <td><b>Age:</b> <span class="font-size"><?php echo get_age($patient->dob); ?></span></td>
                  	<td><b>Date:</b> <span class="font-size"><?php echo date('d/m/Y h:i A', strtotime($patient->created_at)); ?></span></td>
                </tr>
                <tr>
                  	<td><b>Gender:</b> <span class="font-size"><?php echo $this->lang->line($patient->gender); ?></span></td>
                    <td><b>Blood Group:</b> <span class="font-size"><?php echo $this->lang->line($patient->blood_group); ?></span></td>
                </tr>
                <tr>
                    <td><b>Address:</b> <span class="font-size"><?php echo $patient->address; ?></span></td>
                    <td><b>Contact No:</b> <span class="font-size"><?php echo $patient->phone; ?></span></td>
                </tr>
                
                <tr>
                    <td colspan="2"><b>Consultant Name:</b> <span class="font-size" style="text-transform: uppercase; font-size: 12px;"><?php echo $patient->doctor; ?>, <?php echo $patient->specialist; ?></span></td>
                </tr>
            </table>
            <!-- Patient Info End-->

            <!-- Service Table -->
            <table class="table service_table">
                <thead>
                    <tr>
                        <th style="padding-left: 5px; text-align: left;" width="65%">Service Name</th>
                        <th style="padding-right: 5px; text-align: right;" width="35%">Price (Tk.)</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="padding-left: 5px; text-align: left;">OPD Consultation Fee</td>
                        <td style="padding-right: 5px; text-align: right;"><?php echo $patient->doctor_charge; ?></td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <table class="table" style="border: none; margin: 5px 0;">
                                <tbody>
                                    <tr>
                                        <td width="65%" rowspan="4" style="border: none;">
                                            <div class="paid">
                                                Paid
                                            </div>
                                            <p><b>In Word:</b> <?php echo $this->numbertowords->convert_number($patient->doctor_charge - $patient->discount); ?> Taka Only.</p>
                                        </td>
                                        <td width="25%" style="border: none;">Total Tk.</td>
                                        <td width="10%" style="border: none; padding-right: 5px; text-align: right;"><?php echo $patient->doctor_charge; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="border">(-)Discount Tk.</td>
                                        <td style="border-top: 1px dashed #000; padding-right: 5px; text-align: right;" class="border"><?php echo $patient->discount; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="border">Net Payable Tk.</td>
                                        <td style="border-top: 1px dashed #000; padding-right: 5px; text-align: right;" class="border"><?php echo number_format($patient->doctor_charge - $patient->discount, 2); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="border"><b>Due Tk.</b></td>
                                        <td style="border-top: 1px dashed #000; padding-right: 5px; text-align: right;" class="border">0.00</td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <?php if ($patient->note != NULL) { ?>
            <p style="text-align: left; margin-top: 20px;">
                <b>Remark:</b>
                <?php echo $patient->note; ?>
            </p>
        <?php } ?>
        <p style="text-align: left; margin-top: 50px;">
            <b>Prepared By:</b>
            <?php echo $patient->create_by; ?>
        </p>
    </div>
</body>

</html>