<style type="text/css">
    ol {
        margin: 0;
        padding: 0;
        padding-left: 30px;
    }

    ol.sortable {
        margin: 0 0 0 0px;
        padding: 0;
        list-style-type: none;
    }

    ol.sortable ol {
        margin: 0 0 0 25px;
        padding: 0;
        list-style-type: none;
    }

    .sortable li {
        margin: 7px 0 0 0;
        padding: 0;
        position: relative;
    }

    .ui-sortable-handle a {
        color: #444;
    }

    .sortable li div:after {
        content: "\f022";
        position: absolute;
        top: 6px;
        left: 10px;
        font-size: 15px;
        font-family: 'FontAwesome';
        cursor: move;
    }

    .sortable li div {
        display: block;
        margin-bottom: 5px;
        border: 1px solid #d2d6de;
        background: rgb(238, 238, 239);
        text-transform: uppercase;
        text-decoration: none;
        padding: 5px 5px 5px 30px;
        margin: 0;
        cursor: move;
    }
</style>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('menu'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_menu'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-8 -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'frontend', 'menu')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bars font-30 mr-10"></i>
                            <?php echo $this->lang->line('menu'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(VIEW, 'frontend', 'menu')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontend/menu'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('menu'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <?php if (isset($menu_item) && !empty($menu_item)) { ?>
                    <?php echo form_open_multipart(site_url('frontend/menu/index/' . $this->uri->segment(4, 0) . '/' . $this->uri->segment(5, 0)), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <?php } else { ?>
                    <?php echo form_open_multipart(site_url('frontend/menu/index/' . $this->uri->segment(4, 0)), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <?php } ?>
                <div class="card-body pt-0">
                    <div class="form-row">
                        <input type="hidden" name="menu_id" value="<?php echo $this->uri->segment(4, 0); ?>">
                        <div class="col-md-6 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($menu_item->name) ?  $menu_item->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="title" class="form-text text-muted">
                                <?php echo form_error('title'); ?>
                            </small>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('bn_name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($menu_item->bn_name) ?  $menu_item->bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('bn_name'); ?>" required autocomplete="off">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bn_name" class="form-text text-muted">
                                <?php echo form_error('bn_name'); ?>
                            </small>
                        </div>
                        <div class="col-md-4  mb-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="open_new_tab" id="open_new_tab" value="1" <?php echo isset($menu_item->open_new_tab) && $menu_item->open_new_tab == 1 ?  'checked' : ''; ?>>
                                <label class="custom-control-label" for="open_new_tab"><?php echo $this->lang->line('open_new_tab'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4  mb-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="external_url" id="external_url" value="1" <?php echo isset($menu_item->external_url) && $menu_item->external_url == 1 ?  'checked' : ''; ?>>
                                <label class="custom-control-label" for="external_url"><?php echo $this->lang->line('external_url'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4  mb-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo isset($menu_item->status) && $menu_item->status == 1 ?  'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="ext_url_link"><?php echo $this->lang->line('ext_url_link'); ?></label>
                            <input disabled class="form-control" name="ext_url_link" id="ext_url_link" value="<?php echo isset($menu_item->ext_url_link) ?  $menu_item->ext_url_link : ''; ?>" placeholder="<?php echo $this->lang->line('ext_url_link'); ?>" type="text" autocomplete="off">
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="page_id"><?php echo $this->lang->line('page'); ?></label>
                            <select class="form-control select2" name="page_id" id="page_id">
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($pages as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($menu_item->page_id) && $menu_item->page_id == $obj->id ?  'selected="selected"' : ''; ?>><?php echo $obj->title; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <?php if (isset($menu_item->id) && $menu_item->id > 0) { ?>
                            <input type="hidden" name="id" value="<?php echo $menu_item->id; ?>">
                        <?php } ?>
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend/menu'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo isset($menu_item->id) ? $this->lang->line('update') : $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'frontend', 'menu')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bars font-30 mr-10"></i>
                            <?php echo $this->lang->line('menu'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                </div>
                <div class="card-body pt-0">
                    <div class="cf nestable-lists">
                        <div class="dd" id="nestable">
                            <?php
                            $ref   = [];
                            $items = [];
                            foreach ($menu_items as $obj) {
                                $thisRef = &$ref[$obj->id];
                                $thisRef['parent_id'] = $obj->parent_id;
                                $thisRef['name'] = $obj->name;
                                $thisRef['id'] = $obj->id;
                                $thisRef['menu_id'] = $obj->menu_id;

                                if ($obj->parent_id == 0) {
                                    $items[$obj->id] = &$thisRef;
                                } else {
                                    $ref[$obj->parent_id]['child'][$obj->id] = &$thisRef;
                                }
                            }
                            ?>

                            <?php
                            function get_menu($items, $class = 'dd-list') {
                                $html = "<ol class=\"" . $class . "\" id=\"menu-id\">";
                                foreach ($items as $key => $value) {
                                    $html .= '<li class="dd-item dd3-item" data-id="' . $value['id'] . '" >
                                            <div class="dd-handle dd3-handle">&nbsp;</div>
                                            <div class="dd3-content">
                                                <span id="label_show' . $value['id'] . '">' . $value['name'] . '</span> 
                                                <span class="pull-right">
                                                    <a class="btn btn-xs btn-primary" href="' . site_url('frontend/menu/index/' . $value['menu_id'] . '/' . $value['id']) . '"><i class="fa fa-pencil"></i></a>
                                                    <a class="btn btn-xs btn-danger" href="' . site_url('frontend/menu/delete_menu_item/' . $value['id']) . '"><i class="fa fa-trash"></i></a>
                                                </span>    
                                            </div>';
                                    if (array_key_exists('child', $value)) {
                                        $html .= get_menu($value['child'], 'child');
                                    }
                                    $html .= "</li>";
                                }
                                $html .= "</ol>";
                                return $html;
                            }
                            echo  get_menu($items);
                            ?>
                        </div>
                    </div>
                    <textarea style="display: none;" id="nestable-output"></textarea>
                </div>
                <!-- Card Footer -->
                <div class="card-footer">
                    <button type="button" id="saveMenu" class="btn btn-sm btn-success pull-right"><?php echo $this->lang->line('submit'); ?></button>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<!-- nestable -->
<link rel="stylesheet" href="<?php echo VENDOR_URL; ?>nestable/style.css">
<script src="<?php echo VENDOR_URL; ?>nestable/nestable.js"></script>

<script>
    $(".select2").select2();

    $(document).ready(function() {
        var updateOutput = function(e) {
            var list = e.length ? e : $(e.target),
                output = list.data('output');
            if (window.JSON) {
                output.val(window.JSON.stringify(list.nestable('serialize'))); //, null, 2));
            } else {
                output.val('JSON browser support required for this demo.');
            }
        };

        // activate Nestable for list 1
        $('#nestable').nestable({
            group: 1
        }).on('change', updateOutput);

        // output initial serialised data
        updateOutput($('#nestable').data('output', $('#nestable-output')));
    });


    $('#external_url').change(function() {
        var c = this.checked ? 1 : 0;
        if (c) {
            $('#ext_url_link').prop("disabled", false);
        } else {
            $('#ext_url_link').prop("disabled", true);

        }
    });

    $("#saveMenu").click(function() {
        var dataString = {
            data: $("#nestable-output").val(),
        };
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('frontend/menu/save_menu'); ?>",
            data: dataString,
            cache: false,
            success: function(data) {
                $.toast({
                    text: "<?php echo $this->lang->line('update_success'); ?>",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-success',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            },
            error: function(xhr, status, error) {
                alert(error);
            },
        });
    });
</script>