<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('menu'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_menu'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('frontend/left-side'); ?>
        <!-- col-lg-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'frontend', 'menu')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bars font-30 mr-10"></i>
                            <?php echo $this->lang->line('menu'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(ADD, 'frontend', 'menu')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontend/menu/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('menu'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('bn_name'); ?></th>
                                        <th><?php echo $this->lang->line('sort_by'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th width="20%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1;
                                    if (isset($menus) && !empty($menus)) { ?>
                                        <?php foreach ($menus as $obj) { ?>
                                            <tr>
                                                <td><?php echo $count++; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->bn_name; ?></td>
                                                <td><?php echo $obj->sort_by; ?></td>
                                                <td><?php echo $obj->status ? '<span class="badge badge-success">' .  $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' .  $this->lang->line('in_active') . '</span>'; ?></td>
                                                <td>
                                                    <?php if (has_permission(ADD, 'frontend', 'menu')) { ?>
                                                        <a class="btn btn-xs btn-info" href="<?php echo site_url('frontend/menu/index/' . $obj->id); ?>"> <i class="fa fa-plus text-white"></i> </a>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'frontend', 'menu')) { ?>
                                                        <a href="<?php echo site_url('frontend/menu/edit/' . $obj->id); ?>" class="btn btn-xs btn-success mr-5"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'frontend', 'menu')) { ?>
                                                        <a class="btn btn-xs btn-danger" href="<?php echo site_url('frontend/menu/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="6"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->