<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('doctor'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_doctor'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('doctor/left-side'); ?>
        <!-- col-lg-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'doctor', 'doctor')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-md font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('doctor'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'doctor', 'doctor')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('doctor'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('doctor/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('bn_name'); ?></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($bn_name) ?  $bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('bn_name'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" min="0" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('phone'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="bmdc_reg_no"><?php echo $this->lang->line('bmdc_reg_no'); ?></label>
                            <input type="text" class="form-control" name="bmdc_reg_no" id="bmdc_reg_no" value="<?php echo isset($bmdc_reg_no) ?  $bmdc_reg_no : ''; ?>" placeholder="<?php echo $this->lang->line('bmdc_reg_no'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('department_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($designation_id) && $designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('designation_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="national_id"><?php echo $this->lang->line('national_id'); ?></label>
                            <input type="number" class="form-control" name="national_id" id="national_id" value="<?php echo isset($national_id) ?  $national_id : ''; ?>" placeholder="<?php echo $this->lang->line('national_id'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-8 mb-10">
                            <label for="specialist"><?php echo $this->lang->line('specialist'); ?></label>
                            <input type="text" class="form-control" name="specialist" id="specialist" value="<?php echo isset($specialist) ?  $specialist : ''; ?>" placeholder="<?php echo $this->lang->line('specialist'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="specialist" class="form-text text-muted">
                                <?php echo form_error('specialist'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="birth_date"><?php echo $this->lang->line('birth_date'); ?></label>
                            <input type="text" class="form-control" name="dob" id="dob" value="<?php echo isset($dob) ?  $dob : ''; ?>" placeholder="<?php echo $this->lang->line('birth_date'); ?>" autocomplete="off">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('birth_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="joining_date"><?php echo $this->lang->line('join_date'); ?></label>
                            <input type="text" class="form-control" name="joining_date" id="joining_date" value="<?php echo isset($joining_date) ?  $joining_date : ''; ?>" placeholder="<?php echo $this->lang->line('join_date'); ?>" autocomplete="off">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                            <select class="form-control custom-select" name="gender" id="gender" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $genders = get_genders(); ?>
                                <?php foreach ($genders as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('gender'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="religion"><?php echo $this->lang->line('religion'); ?></label>
                            <select class="form-control custom-select" name="religion" id="religion">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $religions = get_religion(); ?>
                                <?php foreach ($religions as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($religion) && $religion == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('religion'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="blood_group"><?php echo $this->lang->line('blood_group'); ?></label>
                            <select class="form-control custom-select" name="blood_group" id="blood_group">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $bloods = get_blood_group(); ?>
                                <?php foreach ($bloods as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($blood_group) && $blood_group == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="marital_status"><?php echo $this->lang->line('marital_status'); ?></label>
                            <select class="form-control custom-select" name="marital_status" id="marital_status">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $marital_status = get_marital_status(); ?>
                                <?php foreach ($marital_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($marital_status) && $marital_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="present_address" id="present_address" aria-label="<?php echo $this->lang->line('present'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($present_address) ?  $present_address : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="permanent_address" id="permanent_address" aria-label="<?php echo $this->lang->line('permanent'); ?> <?php echo $this->lang->line('address'); ?>"><?php echo isset($permanent_address) ?  $permanent_address : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('role'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN, PATIENT))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo $obj->id == DOCTOR ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('role_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="text" class="form-control" name="email" id="email" value="<?php echo isset($email) ?  $email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="username"><?php echo $this->lang->line('username'); ?></label>
                            <input type="text" class="form-control" name="username" id="username" value="<?php echo isset($username) ?  $username : random_string('nozero', 6); ?>" placeholder="<?php echo $this->lang->line('username'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('username'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="password"><?php echo $this->lang->line('password'); ?></label>
                            <input type="text" class="form-control" name="password" id="password" value="<?php echo isset($password) ?  $password : random_string('nozero', 6); ?>" placeholder="<?php echo $this->lang->line('password'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('password'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="device_id "><?php echo $this->lang->line('device_id'); ?></label>
                            <input type="number" class="form-control" name="device_id" id="device_id" value="<?php echo isset($device_id) ?  $device_id : $this->doctor->get_custom_id('employees', '1'); ?>" placeholder="<?php echo $this->lang->line('device_id'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($sort_by) ?  $sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="photo"><?php echo $this->lang->line('photo'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="photo">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="signature"><?php echo $this->lang->line('signature'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="signature">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="resume"><?php echo $this->lang->line('resume'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="resume">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mt-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_home" id="is_view_on_web" value="1" checked>
                                <label class="custom-control-label" for="is_view_on_home"><?php echo $this->lang->line('is_view_on_home'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4 mt-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_web" id="is_view_on_web" value="1" checked>
                                <label class="custom-control-label" for="is_view_on_web"><?php echo $this->lang->line('is_view_on_web'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4 mt-10">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                      	<div class="col-md-12 mt-10 mb-10">
                            <div class="tinymce-wrap">
                                <textarea class="tinymce template" name="ultrasonography" id="ultrasonography" placeholder="<?php echo $this->lang->line('ultrasonography'); ?>"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('doctor'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>
<!-- Tinymce JavaScript -->
<script src="<?php echo VENDOR_URL; ?>tinymce/tinymce.min.js"></script>
<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $("#dob, #joining_date").daterangepicker({
        autoUpdateInput: false,
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
    $('input[id="dob"], input[id="joining_date"]').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });
  	
  	$(function() {
        "use strict";
        tinymce.init({
            selector: '.tinymce',
            height: 150,
            statusbar: false,
            setup: function(editor) {
                editor.on('change', function() {
                    tinymce.triggerSave();
                });
            },
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table contextmenu paste code'
            ],
            toolbar: 'code || fullscreen || insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent',

        });
    });
</script>

<script>
    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>