<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('schedule'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_schedule'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('doctor/schedule/search'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="slot"><?php echo $this->lang->line('slot'); ?></label>
                            <select class="form-control custom-select" name="slot" id="slot" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('slot'); ?></option>
                                <?php $slots = get_schedule_slot(); ?>
                                <?php foreach ($slots as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($slot) && $slot == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="status" id="status">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('status'); ?></option>
                                <option value="1" <?php echo isset($status) && $status == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('in_active'); ?></option>
                                <option value="2" <?php echo isset($status) && $status == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('active'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>


        <?php if (isset($schedules) && !empty($schedules)) { ?>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(ADD, 'doctor', 'schedule')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-clock-o font-30 mr-10"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('schedule'); ?>
                            </h6>
                        <?php } ?>
                        <?php if (has_permission(VIEW, 'doctor', 'schedule')) { ?>
                            <div class="align-items-center">
                                <a href="<?php echo site_url('doctor/schedule'); ?>" class="btn btn-xs btn-primary">
                                    <i class="fa fa-list font-12 mr-5"></i>
                                    <?php echo $this->lang->line('schedule'); ?> <?php echo $this->lang->line('list'); ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>

                    <?php echo form_open_multipart(site_url('doctor/schedule/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th width="5%"><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th width="25%"><?php echo $this->lang->line('doctor'); ?></th>
                                            <th width="10%"><?php echo $this->lang->line('date'); ?></th>
                                            <th width="10%"><?php echo $this->lang->line('slot'); ?></th>
                                            <th width="15%"><?php echo $this->lang->line('start_time'); ?></th>
                                            <th width="15%"><?php echo $this->lang->line('end_time'); ?></th>
                                            <th width="15%"><?php echo $this->lang->line('per_patient_time'); ?></th>
                                            <th width="5%"><?php echo $this->lang->line('status'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        foreach ($schedules as $key => $obj) {  ?>
                                            <tr>
                                                <td><?php echo $key + 1; ?></td>
                                                <td>
                                                    <?php
                                                    if (isset($doctor_id) && !empty($doctor_id)) {
                                                        echo $doctor->name;
                                                    } else {
                                                        echo $obj->doctor;
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if (isset($doctor_id) && !empty($doctor_id)) {
                                                        echo $obj->format("d-m-Y") . '<br>' . date("l", strtotime($obj->format("d-m-Y")));
                                                        $schedule = $this->schedule->get_single('doctor_schedules', array('doctor_id' => $doctor_id, 'slot' => $slot, 'date' => $obj->format("Y-m-d")));
                                                    } else {
                                                        echo $form_date . '<br>' . date("l", strtotime($form_date));
                                                        $schedule = $this->schedule->get_single('doctor_schedules', array('doctor_id' => $obj->doctor_id, 'slot' => $slot, 'date' => $form_date));
                                                    }
                                                    ?>
                                                    <input type="hidden" name="doctor_schedules[]" value="<?php echo isset($doctor_id) && !empty($doctor_id) ? $key + 1 : $obj->doctor_id; ?>">
                                                    <input type="hidden" name="doctor_id[<?php echo isset($doctor_id) && !empty($doctor_id) ? $key + 1 : $obj->doctor_id; ?>]" value="<?php echo isset($doctor_id) && !empty($doctor_id) ? $doctor->user_id : $obj->doctor_id; ?>">
                                                    <input type="hidden" name="slot" value="<?php echo $slot ?? 'morning'; ?>">
                                                    <input type="hidden" name="date[<?php echo isset($doctor_id) && !empty($doctor_id) ? $key + 1 : $obj->doctor_id; ?>]" value="<?php echo isset($doctor_id) && !empty($doctor_id) ? $obj->format("Y-m-d") : $form_date; ?>">
                                                </td>
                                                <td><?php echo  $this->lang->line($slot); ?></td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm time" name="start_time[<?php echo isset($doctor_id) && !empty($doctor_id) ? $key + 1 : $obj->doctor_id; ?>]" id="start_time_<?php echo $key + 1; ?>" value="<?php echo isset($schedule) && $schedule->start_time ? $schedule->start_time : ''; ?>" placeholder="<?php echo $this->lang->line('start_time'); ?>">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm time" name="end_time[<?php echo isset($doctor_id) && !empty($doctor_id) ? $key + 1 : $obj->doctor_id; ?>]" id="end_time_<?php echo $key + 1; ?>" value="<?php echo isset($schedule) && $schedule->end_time ? $schedule->end_time : ''; ?>" placeholder="<?php echo $this->lang->line('end_time'); ?>">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" name="remark[<?php echo isset($doctor_id) && !empty($doctor_id) ? $key + 1 : $obj->doctor_id; ?>]" id="remark_<?php echo $key + 1; ?>" value="<?php echo isset($schedule) && $schedule->remark ? $schedule->remark : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                                                </td>
                                                <td>
                                                    <?php
                                                    if (isset($schedule->status) && $schedule->status == 1) {
                                                        $check = 'checked';
                                                    } elseif (isset($schedule->status) && $schedule->status == 0) {
                                                        $check = '';
                                                    } else {
                                                        $check = 'checked';
                                                    }
                                                    ?>
                                                    <div class="custom-control custom-checkbox checkbox-success">
                                                        <input type="checkbox" class="custom-control-input" name="status[<?php echo isset($doctor_id) && !empty($doctor_id) ? $key + 1 : $obj->doctor_id; ?>]" id="status_<?php echo $key + 1; ?>" value="1" <?php echo $check; ?>>
                                                        <label class="custom-control-label" for="status_<?php echo $key + 1; ?>"><?php echo $this->lang->line('status'); ?></label>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <div class="card-footer pt-0 d-flex justify-content-end">
                        <div class="button-list">
                            <a class="btn btn-gradient-danger" href="<?php echo site_url('doctor/schedule'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                            <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<!-- Time Picker -->
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.css" rel="stylesheet" type="text/css" />
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker-theme.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('.time').mdtimepicker({
        timeFormat: 'hh:mm:ss.000',
        format: 'h:mm tt',
        // theme of the timepicker
        // 'red', 'purple', 'indigo', 'teal', 'green', 'dark'
        theme: 'teal',
        readOnly: false,
        hourPadding: false,
        clearBtn: true
    });

    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>