<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('event'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('event'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('announcement/left-side'); ?>
        <!-- col-xl-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'announcement', 'event')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-calendar font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('event'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'announcement', 'event')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('announcement/event'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('event'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('announcement/event/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('event_for'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($role_id) && $role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-9 mb-10">
                            <label for="title"><?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="title" id="title" value="<?php echo isset($title) ?  $title : ''; ?>" placeholder="<?php echo $this->lang->line('title'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="event_place"><?php echo $this->lang->line('event_place'); ?></label>
                            <input type="text" class="form-control" name="event_place" id="event_place" value="<?php echo isset($event_place) ?  $event_place : ''; ?>" placeholder="<?php echo $this->lang->line('event_place'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="event_from"><?php echo $this->lang->line('from_date'); ?></label>
                            <input type="text" class="form-control" name="event_from" id="event_from" value="<?php echo isset($event_from) ?  $event_from : ''; ?>" placeholder="<?php echo $this->lang->line('from_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="event_to"><?php echo $this->lang->line('to_date'); ?></label>
                            <input type="text" class="form-control" name="event_to" id="event_to" value="<?php echo isset($event_to) ?  $event_to : ''; ?>" placeholder="<?php echo $this->lang->line('to_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_web" id="is_view_on_web" value="1" checked>
                                <label class="custom-control-label" for="is_view_on_web"><?php echo $this->lang->line('is_view_on_web'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="image"><?php echo $this->lang->line('image'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="image">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="tinymce-wrap">
                                <textarea class="tinymce" name="description" id="description"><?php echo isset($description) ?  $description : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('announcement/event'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>


<script>
    $("#event_from, #event_to").daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY/MM/DD HH:mm',
        }
    });
</script>

<!-- Tinymce JavaScript -->
<script src="<?php echo VENDOR_URL; ?>tinymce/tinymce.min.js"></script>
<script>
    $(function() {
        "use strict";
        tinymce.init({
            selector: '.tinymce',
            height: 200,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table contextmenu paste code'
            ],
            toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
        });
    });
</script>