<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/* * ***************Cron.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Cron
 * @description     : This class used to handle cron job attendence functionality 
 *                    of the application.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : http://hms.sbitzone.com/  
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team	
 * ********************************************************** */
class Cron extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Dashboard_Model', 'dashboard', true);

        $this->global_setting = $this->db->get_where('global_setting', array('status' => 1))->row();
        if ($this->global_setting) {
            date_default_timezone_set($this->global_setting->time_zone);
        }
    }

    public function attendance() {

        $today =  date('Y-m-d');

        // Get Employee info
        $employees = $this->dashboard->get_employee_list();

        // Weekend
        if (isset($employees) && !empty($employees)) {
            foreach ($employees as $employee) {
                // Get Shift Data
                $shift = $this->dashboard->get_single('shifts', array('id' => $employee->shift_id));
                if (isset($shift) && $shift->weekend == strtolower(date('l'))) {
                    // Get Attendance data
                    $attendance = $this->dashboard->get_single('attendances', array('user_id' => $employee->user_id, 'date' => $today));

                    if (isset($attendance) && !empty($attendance)) {
                        if (isset($attendance) && $attendance->attendance_status != 'p' && $attendance->attendance_status != 'a' && $attendance->attendance_status != 'l') {
                            $data['user_id'] = $employee->user_id;
                            $data['shift_id'] = $employee->shift_id;
                            $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                            $data['punch_type'] = 'finger';
                            $data['date'] = date('Y-m-d');
                            $data['attendance_status'] = 'w';
                            $data['status'] = 1;
                            $data['created_at'] = date('Y-m-d H:i:a');
                            $this->dashboard->update("attendances", $data, array('user_id' => $attendance->user_id, 'date' => $attendance->date));
                        }
                    } else {
                        $data['user_id'] = $employee->user_id;
                        $data['shift_id'] = $employee->shift_id;
                        $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                        $data['punch_type'] = 'finger';
                        $data['date'] = date('Y-m-d');
                        $data['attendance_status'] = 'w';
                        $data['status'] = 1;
                        $data['created_at'] = date('Y-m-d H:i:a');
                        $this->dashboard->insert("attendances", $data);
                    }
                }
            }
        }

        // Holiday
        $holidays = $this->dashboard->get_today_holiday($today);

        if (isset($holidays) && !empty($holidays)) {
            foreach ($holidays as $holiday) {
                foreach ($employees as $employee) {
                    // Get Attendance data
                    $attendance = $this->dashboard->get_single('attendances', array('user_id' => $employee->user_id, 'date' => $today));
                    if (isset($attendance) && !empty($attendance)) {
                        if ($attendance->attendance_status != 'p' && $attendance->attendance_status != 'a' && $attendance->attendance_status != 'l') {
                            $data['user_id'] = $employee->user_id;
                            $data['shift_id'] = $employee->shift_id;
                            $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                            $data['punch_type'] = 'finger';
                            $data['date'] = date('Y-m-d');
                            $data['attendance_status'] = 'h';
                            $data['status'] = 1;
                            $data['created_at'] = date('Y-m-d H:i:a');
                            $this->dashboard->update("attendances", $data, array('user_id' => $attendance->user_id, 'date' => $attendance->date));
                        }
                    } else {
                        $data['user_id'] = $employee->user_id;
                        $data['shift_id'] = $employee->shift_id;
                        $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                        $data['punch_type'] = 'finger';
                        $data['date'] = date('Y-m-d');
                        $data['attendance_status'] = 'h';
                        $data['status'] = 1;
                        $data['created_at'] = date('Y-m-d H:i:a');
                        $this->dashboard->insert("attendances", $data);
                    }
                }
            }
        }

        // Leave
        $leaves = $this->dashboard->get_today_leave($today);
        if (isset($leaves) && !empty($leaves)) {
            foreach ($leaves as $leave) {
                // Get Employee info
                $employee = $this->dashboard->get_single('employees', array('user_id' => $leave->user_id));

                // Get Attendance date
                $attendance = $this->dashboard->get_single('attendances', array('user_id' => $leave->user_id, 'date' => $today));
                if (isset($attendance) && !empty($attendance)) {
                    if (isset($attendance) && $attendance->attendance_status != 'p' && $attendance->attendance_status != 'a') {
                        $data['user_id'] = $leave->user_id;
                        $data['shift_id'] = $employee->shift_id;
                        $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                        $data['punch_type'] = 'finger';
                        $data['date'] = date('Y-m-d');
                        $data['attendance_status'] = 'l';
                        $data['status'] = 1;
                        $data['created_at'] = date('Y-m-d H:i:a');
                        $this->dashboard->update("attendances", $data, array('user_id' => $attendance->user_id, 'date' => $attendance->date));
                    }
                } else {
                    $data['user_id'] = $leave->user_id;
                    $data['shift_id'] = $employee->shift_id;
                    $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                    $data['punch_type'] = 'finger';
                    $data['date'] = date('Y-m-d');
                    $data['attendance_status'] = 'l';
                    $data['status'] = 1;
                    $data['created_at'] = date('Y-m-d H:i:a');
                    $this->dashboard->insert("attendances", $data);
                }
            }
        }

        // Absent
        if (isset($employees) && !empty($employees)) {
            foreach ($employees as $employee) {
                // Get Shift Data
                $shift = $this->dashboard->get_single('shifts', array('id' => $employee->shift_id));
                // Get Attendance date
                $attendance = $this->dashboard->get_single('attendances', array('user_id' => $employee->user_id, 'date' => $today));

                if (isset($attendance) && !empty($attendance)) {
                    if (isset($attendance) && $attendance->attendance_status == 'a') {
                        $data['user_id'] = $employee->user_id;
                        $data['shift_id'] = $employee->shift_id;
                        $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                        $data['punch_type'] = 'finger';
                        $data['date'] = date('Y-m-d');
                        $data['attendance_status'] = 'a';
                        $data['status'] = 1;
                        $data['created_at'] = date('Y-m-d H:i:a');
                        $this->dashboard->update("attendances", $data, array('user_id' => $attendance->user_id, 'date' => $attendance->date));
                    }
                } else {
                    if (isset($shift) && strtotime($shift->absent_time) < strtotime(date('H:i:s')) && $shift->weekend != strtolower(date('l'))) {
                        $data['user_id'] = $employee->user_id;
                        $data['shift_id'] = $employee->shift_id;
                        $data['is_manual'] = 1; // 0 = Machine, 1 = Manual
                        $data['punch_type'] = 'finger';
                        $data['date'] = date('Y-m-d');
                        $data['attendance_status'] = 'a';
                        $data['status'] = 1;
                        $data['created_at'] = date('Y-m-d H:i:a');
                        $this->dashboard->insert("attendances", $data);
                    }
                }
            }
        }
    }
}
